Attribute VB_Name = "TCPDAQ"

' Destination Module port number

Global Const TCP_MODBUS_PORT = 502              ' MODBUS/TCP
Global Const UDP_ASC_PORT = 1025                ' UDP ASCII Command
Global Const UDP_BROADCAST_PORT = 5048
Global Const BROADCAST_IP = "255.255.255.255"
Global Const TCP_STREAM_PORT = 5168             ' Stream/Event

Global Const MAXMODULES = 64
Global Const SORT_MODULE_IP = 10
Global Const SORT_MODULE_ID = 11
Global Const SORT_MODULE_NO = 12

'Using these function libraries,you can read the error message from the returning codes//

Global Const TCP_NOERROR                =0    'No_error
Global Const TCP_STARTUPFAILURE         =-1   'Windows winsock2 start up error
Global Const TCP_SOCKETFAILURE          =-2   'Can not create TCP socket
Global Const TCP_UDPSOCKETFAILURE       =-3   'Can not create UDP socket
Global Const TCP_SETTIMEOUTFAILURE      =-4   'Can not set TCP/IP timeout
Global Const TCP_SENDFAILURE            =-5   'Can not send package to destination
Global Const TCP_RECEIVEFAILURE         =-6   'No package received until timeout
Global Const TCP_INVALIDRANGEFAILURE    =-7   'Invalid range
Global Const TCP_CREATEWSAEVENTFAILURE  =-8
Global Const TCP_READSTREAMDATAFAILURE  =-9   'Unable to read stream data
Global Const TCP_INVALIDIP              =-10  'Invalid IP address
Global Const TCP_THISIPNOTCONNECTED     =-11  'No Connection to remote IP address
Global Const TCP_ALARMINFOEMPTY         =-12  'Alarm event buffer empty
Global Const TCP_STREAMINFOEMPTY        =-13  'Stream event buffer empty
Global Const TCP_NOTSUPPORTMODULE       =-14  'Not supported module
Global Const TCP_NOTOPEN                =-15  'TCPDAQ.DLL is not opened
Global Const TCP_MEMALLOCERROR          =-16  'Unable to allocate memory
Global Const TCP_INVALIDID              =-17  'illegal ID number
Global Const TCP_PINGTIMEOUT            =-18  'Can not ping remote IP address


Global Const WAIT_OBJECT_0 = 0&
Global Const WAIT_TIMEOUT = &H102&

' Types of EX9017 module '
Global Const TCP_BI_10V = 0                       ' -10V~10V
Global Const TCP_BI_5V = 1                        ' -5V~5V
Global Const TCP_BI_2Point5V = 2                  ' -2.5V~2.5V
Global Const TCP_BI_1V = 3                        ' -1V~1V
Global Const TCP_BI_500mV = 4                     ' -500mV~500mV
Global Const TCP_BI_150mV = 5                     ' -150mV~150mV
Global Const TCP_BI_100mV = 6                     ' -100mV~100mV
Global Const TCP_BI_50mV = 7                      ' -50mV~50mV
Global Const TCP_BI_15mV = 8                      ' -15mV~ 15mV
Global Const TCP_UNI_4TO20mA = 9                  ' 4~20mA
Global Const TCP_UNI_0TO20mA = 10                 ' 0~20mA
Global Const TCP_BI_20mA = 11                     ' -20~20mA

' Types of EX9019 module '
Global Const TCP_TypeJ = 14                       ' TypeJ 0~760'C
Global Const TCP_TypeK = 15                       ' TypeK 0~1370'C
Global Const TCP_TypeT = 16                       ' TypeT -100~400'C
Global Const TCP_TypeE = 17                       ' TypeE 0~1000'C
Global Const TCP_TypeR = 18                       ' TypeR 500~1750'C
Global Const TCP_TypeS = 19                       ' TypeS 500-1750'C
Global Const TCP_TypeB = 20                       ' TypeB 500~1800'C
'-- Types of EX-9015  module ---
Global Const TCP_PT100_50TO150A = 32              ' PT100(a=385) 50~15'C
Global Const TCP_PT100_0TO100A = 33               ' PT100(a=385) 0~100'C
Global Const TCP_PT100_0TO200A = 34               ' PT100(a=385) 0~200'C
Global Const TCP_PT100_0TO400A = 35               ' PT100(a=385) 0~400'C
Global Const TCP_PT100_200TO200A = 36             ' PT100(a=385) -200~200'C
Global Const TCP_PT100_50TO150B = 37              ' PT100(a=392) -50~150'C
Global Const TCP_PT100_0TO100B = 38               ' PT100(a=392) 0~100'C
Global Const TCP_PT100_0TO200B = 39               ' PT100(a=392) 0~200'C
Global Const TCP_PT100_0TO400B = 40               ' PT100(a=392) 0~400'C
Global Const TCP_PT100_200TO200B = 41             ' PT100(a=392) -200~200'C
Global Const TCP_PT1000_40TO160 = 42              ' PT1000 -40~160'C
Global Const TCP_BALCO_30TO120 = 43               ' Baclo(500) -30~100'C
Global Const TCP_NI604_80TO100 = 44               ' Ni(604 a=518) -80~100'C
Global Const TCP_NI604_0TO100 = 45                ' Ni(604 a=518) 0~100'C

Type ModuleInfo

   szIP(3) As Byte                'IP address of on line modules
   szGate(3) As Byte              'Gateway on line modules
   szMask(3) As Byte              'Mask of on line modules
   szDHCP    As Byte              'DHCP status
   szID  As Byte                  'Module ID
   szMacAddr(5) As Byte           'MAC address
   szModuleNo  As Integer         'Module number of on line modules
   szbuffer(11)  As Byte          'reserved for TCPDAQ.DLL

End Type

Type AlarmData
   szIP(3) As Byte            ' the IP address which cause the alarm change
   szDateTime(5) As Integer   ' e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   byChannel As Integer       ' the Channel of which cause the alarm change
   byAlarmType As Integer     ' 0: Low Alarm, 1: High Alarm
   byAlarmStatus As Integer   ' 0: Alarm Off, 1: Alarm On
   szValue As Integer
End Type

Type StreamData
   szIP(3) As Byte          ' the IP address which cause the alarm change
   szDateTime(5) As Integer ' e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   DIN As Integer           ' DI/DO data for Slot0, Slot1,...., Slot7
   dout As Integer          ' AI/AO data for slot0
   wData(31) As Integer     ' AI/AO data for slot1
End Type


Type ModuleData                'All data for module used for function TCP_ReadAllDataFromModule (..)
   DIN(15) As Byte             'Digital input data (DI#0~DI#15),avaliable for EX9050,9051,9052
   dout(15) As Byte            'Digital output data (DO#0~DO#15),avaliable for EX9050,9051,9052,9017,9019
   DiLatch(15) As Byte         'Digital input latch status (DI#0~DI#15),avaliable for EX9050,9051,9052
   DiCounter(15) As Long       'Digital input counter value (DI#0~DI#15),avaliable for EX9050,9051,9052
   AiNormalValue(15) As Double 'Analog Input value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiMaxValue(15) As Double    'Analog maximum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiMinValue(15) As Double    'Analog minimum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiHighAlarm(15) As Byte     'Analog high alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiLowAlarm(15) As Byte      'Analog low alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiChannelType(15) As Byte   'Analog channel Type, avaliable for EX9015,9017,9019
   AiBurnOut(15)  As Byte      'Analog channel burn out status,avaliable for EX9019,9015 only
   CJCTemperature As Double    'Cold junction temperature,avaliable for EX9019 only
End Type


Type AIOStreamData
   szIP(3) As Byte           ' the IP address which cause the alarm change
   szDateTime(5) As Integer  ' e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   DIN As Integer            ' DI/DO data for Slot0, Slot1,...., Slot7
   dout As Integer           '  AI/AO data for slot0
   wData(32) As Integer      ' AI/AO data for slot1
End Type

Type DIOStreamData
   szIP(3) As Byte           ' the IP address which cause the alarm change
   szDateTime(5) As Integer  ' e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   DIN As Integer            ' DI/DO data for Slot0, Slot1,...., Slot7
   dout As Integer           '  AI/AO data for slot0
   wData(15) As Long         ' AI/AO data for slot1
End Type

Public Type SECURITY_ATTRIBUTES
   nLength As Long
   lpSecurityDescriptor As Long
   bInheritHandle As Long
End Type

Declare Function WaitForSingleObject Lib "kernel32" (ByVal hHandle As Long, ByVal dwMilliseconds As Long) As Long
Declare Function CreateEvent Lib "kernel32" Alias "CreateEventA" _
                   (lpEventAttributes As SECURITY_ATTRIBUTES, _
                    ByVal bManualReset As Long, _
                    ByVal bInitialState As Long, _
                    ByVal lpName As String) As Long
Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long

'-------------------- TCP -------------------------------'
Declare Sub TCP_Open Lib "TCPDAQ.dll" Alias "_TCP_Open@0" ()
Declare Sub TCP_Close Lib "TCPDAQ.dll" Alias "_TCP_Close@0" ()
Declare Function TCP_Connect Lib "TCPDAQ.dll" Alias "_TCP_Connect@20" _
                   (ByVal szIP As String, ByVal Port As Integer, _
                    ByVal iConnectionTimeout As Long, _
                    ByVal iSendTimeout As Long, _
                    ByVal iReceiveTimeout As Long) As Long
Declare Sub TCP_Disconnect Lib "TCPDAQ.dll" Alias "_TCP_Disconnect@0" ()
Declare Function TCP_ModuleDisconnect Lib "TCPDAQ.dll" Alias "_TCP_ModuleDisconnect@4" _
                   (ByVal szIP As String) As Long
Declare Function TCP_SendData Lib "TCPDAQ.dll" Alias "_TCP_SendData@12" _
                   (ByVal szIP As String, ByRef pData As Byte, ByVal wDataLen As Integer) As Long
Declare Function TCP_RecvData Lib "TCPDAQ.dll" Alias "_TCP_RecvData@12" _
                   (ByVal szIP As String, ByRef pData As Byte, ByVal wDataLen As Integer) As Long
Declare Function TCP_SendReceiveASCcmd Lib "TCPDAQ.dll" Alias "_TCP_SendReceiveASCcmd@12" _
                   (ByVal szIP As String, ByVal TXdata As String, ByVal RXata As String) As Long

'--------------------- UDP -----------------------------------------------'
Declare Function UDP_Connect Lib "TCPDAQ.dll" Alias "_UDP_Connect@24" _
                   (ByVal szIP As String, ByVal S_Port As Integer, ByVal D_Port As Integer, ByVal iConnectionTimeout As Long, _
                    ByVal iSendTimeout As Long, ByVal iReceiveTimeout As Long) As Long
Declare Sub UDP_Disconnect Lib "TCPDAQ.dll" Alias "_UDP_Disconnect@0" ()
Declare Function UDP_ModuleDisconnect Lib "TCPDAQ.dll" Alias "_UDP_ModuleDisconnect@4" _
                   (ByVal szIP As String) As Long
Declare Function UDP_SendData Lib "TCPDAQ.dll" Alias "_UDP_SendData@12" _
                   (ByVal szIP As String, ByRef pData As Byte, ByVal wDataLen As Integer) As Long
Declare Function UDP_RecvData Lib "TCPDAQ.dll" Alias "_UDP_RecvData@12" _
                   (ByVal szIP As String, ByRef pData As Byte, ByVal wDataLen As Integer) As Long
Declare Function UDP_SendReceiveASCcmd Lib "TCPDAQ.dll" Alias "_UDP_SendReceiveASCcmd@12" _
                   (ByVal szIP As String, ByVal TXdata As String, ByVal RXdata As String) As Long

Declare Function TCP_GetLastError Lib "TCPDAQ.dll" Alias "_TCP_GetLastError@0" () As Long
Declare Function TCP_PingIP Lib "TCPDAQ.dll" Alias "_TCP_PingIP@8" (ByVal IPadr As String, ByVal PingTimes As Integer) As Long

'-------------------- Stream -------------------------------'
Declare Function TCP_StartStream Lib "TCPDAQ.dll" Alias "_TCP_StartStream@8" (ByVal IP As String, ByVal hEvent As Long) As Long
Declare Function TCP_StopStream Lib "TCPDAQ.dll" Alias "_TCP_StopStream@0" () As Long
Declare Function TCP_ReadStreamData Lib "TCPDAQ.dll" Alias "_TCP_ReadStreamData@8" (ByVal szIP As String, ByRef lpData As StreamData) As Long

'-------------------- Event ----------------------------------'
Declare Function TCP_StartEvent Lib "TCPDAQ.dll" Alias "_TCP_StartEvent@8" (ByVal IPadr As String, ByVal hEvent As Long) As Long
Declare Function TCP_StopEvent Lib "TCPDAQ.dll" Alias "_TCP_StopEvent@0" () As Long
Declare Function TCP_ReadEventData Lib "TCPDAQ.dll" Alias "_TCP_ReadEventData@8" (ByVal szIP As String, ByRef lpData As AlarmData) As Long

'------------------ Common Module -------------------------------'

Declare Function TCP_GetModuleIPinfo Lib "TCPDAQ.dll" Alias "_TCP_GetModuleIPinfo@8" (ByVal szIP As String, ByRef ModuleIP As ModuleInfo) As Long
Declare Function TCP_GetModuleID Lib "TCPDAQ.dll" Alias "_TCP_GetModuleID@8" (ByVal szIP As String, ByRef ModuleID As Byte) As Long
Declare Function TCP_GetIPFromID Lib "TCPDAQ.dll" Alias "_TCP_GetIPFromID@8" (ByVal IDno As Byte, ByRef szIP As String) As Long
Declare Function TCP_ScanOnLineModules Lib "TCPDAQ.dll" Alias "_TCP_ScanOnLineModules@8" _
                   (ModuleIP As ModuleInfo, ByVal Sortkey As Byte) As Long
Declare Function TCP_GetDLLVersion Lib "TCPDAQ.dll" Alias "_TCP_GetDLLVersion@0" () As Long
Declare Function TCP_GetModuleNo Lib "TCPDAQ.dll" Alias "_TCP_GetModuleNo@8" _
                   (ByVal szIP As String, ByRef Mname As Byte) As Long

Declare Function TCP_ReadAllDataFromModule Lib "TCPDAQ.dll" Alias "_TCP_ReadAllDataFromModule@8" (ByVal szIP As String, _
                    ByRef ModuleData As ModuleData) As Long

'------------------ DIO -------------------------------'
Declare Function TCP_ReadDIOMode Lib "TCPDAQ.dll" Alias "_TCP_ReadDIOMode@12" _
                   (ByVal szIP As String, ByRef byDImode As Byte, ByRef byDOmode As Byte) As Long
Declare Function TCP_ReadDIO Lib "TCPDAQ.dll" Alias "_TCP_ReadDIO@12" _
                   (ByVal szIP As String, ByRef ByDi As Byte, ByRef ByDo As Byte) As Long
Declare Function TCP_ReadDISignalWidth Lib "TCPDAQ.dll" Alias "_TCP_ReadDISignalWidth@12" _
                   (ByVal szIP As String, ByRef ulLoWidth As Long, ByRef ulHiWidth As Long) As Long
Declare Function TCP_WriteDISignalWidth Lib "TCPDAQ.dll" Alias "_TCP_WriteDISignalWidth@12" _
                  (ByVal szIP As String, ByRef ulLoWidth As Long, ByRef ulHiWidth As Long) As Long
Declare Function TCP_ReadDICounter Lib "TCPDAQ.dll" Alias "_TCP_ReadDICounter@8" _
                   (ByVal szIP As String, ByRef ulCounterValue As Long) As Long
Declare Function TCP_ClearDICounter Lib "TCPDAQ.dll" Alias "_TCP_ClearDICounter@8" _
                   (ByVal szIP As String, ByVal wChno As Integer) As Long
Declare Function TCP_StartDICounter Lib "TCPDAQ.dll" Alias "_TCP_StartDICounter@8" _
                   (ByVal szIP As String, ByVal wChno As Integer) As Long
Declare Function TCP_StopDICounter Lib "TCPDAQ.dll" Alias "_TCP_StopDICounter@8" _
                   (ByVal szIP As String, ByVal wChno As Integer) As Long
Declare Function TCP_ClearDILatch Lib "TCPDAQ.dll" Alias "_TCP_ClearDILatch@8" _
                   (ByVal szIP As String, ByVal wChno As Integer) As Long
Declare Function TCP_ReadDILatch Lib "TCPDAQ.dll" Alias "_TCP_ReadDILatch@8" _
                   (ByVal szIP As String, ByRef wLatch As Byte) As Long
Declare Function TCP_WriteDO Lib "TCPDAQ.dll" Alias "_TCP_WriteDO@16" _
                   (ByVal szIP As String, ByVal wStartDO As Integer, ByVal wCount As Integer, _
                    ByRef ByDo As Byte) As Long
Declare Function TCP_WriteDOPulseCount Lib "TCPDAQ.dll" Alias "_TCP_WriteDOPulseCount@12" _
                   (ByVal szIP As String, ByVal wDoChannel As Integer, ByVal ulPulseCount As Long) As Long
Declare Function TCP_WriteDODelayWidth Lib "TCPDAQ.dll" Alias "_TCP_WriteDODelayWidth@24" _
                   (ByVal szIP As String, ByVal wChno As Integer, _
                    ByVal ulLoPulseWidth As Long, ByVal ulHiPulseWidth As Long, _
                    ByVal ulLoDelayWidth As Long, ByVal ulHiDelayWidth As Long) As Long
Declare Function TCP_ReadDODelayWidth Lib "TCPDAQ.dll" Alias "_TCP_ReadDODelayWidth@24" _
                   (ByVal szIP As String, ByVal wChno As Integer, _
                    ByRef ulLoPulseWidth As Long, ByRef ulHiPulseWidth As Long, _
                    ByRef ulLoDelayWidth As Long, ByRef ulHiDelayWidth As Long) As Long

'----------------------- AIO  ----------------------------------------------'
Declare Function TCP_WriteAIAlarmType Lib "TCPDAQ.dll" Alias "_TCP_WriteAIAlarmType@16" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByVal HiLoAlarm As Byte, ByVal AlarmType As Byte) As Long
Declare Function TCP_ReadAIValue Lib "TCPDAQ.dll" Alias "_TCP_ReadAIValue@8" _
                   (ByVal szIP As String, ByRef dlValue As Double) As Long
Declare Function TCP_ReadAITypes Lib "TCPDAQ.dll" Alias "_TCP_ReadAITypes@8" _
                   (ByVal szIP As String, ByRef szRange As Byte) As Long
Declare Function TCP_ReadAIMaxVal Lib "TCPDAQ.dll" Alias "_TCP_ReadAIMaxVal@8" _
                   (ByVal szIP As String, ByRef dMaxValue As Double) As Long
Declare Function TCP_ReadAIMinVal Lib "TCPDAQ.dll" Alias "_TCP_ReadAIMinVal@8" _
                   (ByVal szIP As String, ByRef dMinValue As Double) As Long
Declare Function TCP_WriteAIMultiplexChannel Lib "TCPDAQ.dll" Alias "_TCP_WriteAIMultiplexChannel@8" _
                  (ByVal szIP As String, ByRef szchno As Byte) As Long
Declare Function TCP_ReadAIMultiplexChannel Lib "TCPDAQ.dll" Alias "_TCP_ReadAIMultiplexChannel@8" _
                   (ByVal szIP As String, ByRef szchno As Byte) As Long
Declare Function TCP_ReadAIAverageChannel Lib "TCPDAQ.dll" Alias "_TCP_ReadAIAverageChannel@8" _
                   (ByVal szIP As String, ByRef szchno As Byte) As Long
Declare Function TCP_WriteAIAverageChannel Lib "TCPDAQ.dll" Alias "_TCP_WriteAIAverageChannel@8" _
                   (ByVal szIP As String, ByRef szchno As Byte) As Long
Declare Function TCP_ReadAIAlarmTypes Lib "TCPDAQ.dll" Alias "_TCP_ReadAIAlarmTypes@16" _
                   (ByVal szIP As String, ByVal AIchno As Integer, ByRef HiAlarmType As Byte, ByRef LoAlarmType As Byte) As Long
Declare Function TCP_ReadAIAlarmDOConnection Lib "TCPDAQ.dll" Alias "_TCP_ReadAIAlarmDOConnection@16" _
                   (ByVal szIP As String, ByVal AIchno As Integer, ByRef AIHiAlarmDOchn As Integer, ByRef AILoAlarmDOchn As Integer) As Long
Declare Function TCP_WriteAIAlarmDOConnection Lib "TCPDAQ.dll" Alias "_TCP_WriteAIAlarmDOConnection@16" _
                   (ByVal szIP As String, ByVal AIchno As Integer, ByVal HiAlarmDOchn As Integer, ByVal LoAlarmDOchn As Integer) As Long
Declare Function TCP_ReadAIAlarmStatus Lib "TCPDAQ.dll" Alias "_TCP_ReadAIAlarmStatus@16" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByRef szHighAlarm As Byte, ByRef szLowAlarm As Byte) As Long
Declare Function TCP_ClearAILatchAlarm Lib "TCPDAQ.dll" Alias "_TCP_ClearAILatchAlarm@12" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByVal alarmlevel As Byte) As Long
Declare Function TCP_ClearAIMaxVal Lib "TCPDAQ.dll" Alias "_TCP_ClearAIMaxVal@8" _
                   (ByVal szIP As String, ByVal Chno As Integer) As Long
Declare Function TCP_ClearAIMinVal Lib "TCPDAQ.dll" Alias "_TCP_ClearAIMinVal@8" _
                   (ByVal szIP As String, ByVal Chno As Integer) As Long
Declare Function TCP_ReadAIBurnOutStatus Lib "TCPDAQ.dll" Alias "_TCP_ReadAIBurnOutStatus@8" _
                   (ByVal szIP As String, ByRef dlBurnout As Byte) As Long
Declare Function TCP_WriteAIAlarmLimit Lib "TCPDAQ.dll" Alias "_TCP_WriteAIAlarmLimit@24" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByVal dHighLimit As Double, ByVal dLowLimit As Double) As Long
Declare Function TCP_ReadAIAlarmLimit Lib "TCPDAQ.dll" Alias "_TCP_ReadAIAlarmLimit@16" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByRef dHighLimit As Double, ByRef dLowLimit As Double) As Long
Declare Function TCP_StartAIAlarm Lib "TCPDAQ.dll" Alias "_TCP_StartAIAlarm@12" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByVal alarmlevel As Byte) As Long
Declare Function TCP_StopAIAlarm Lib "TCPDAQ.dll" Alias "_TCP_StopAIAlarm@12" _
                   (ByVal szIP As String, ByVal Chno As Integer, ByVal alarmlevel As Byte) As Long
Declare Function TCP_WriteCJCOffset Lib "TCPDAQ.dll" Alias "_TCP_WriteCJCOffset@12" _
                   (ByVal szIP As String, ByVal CJoffset As Double) As Long
Declare Function TCP_ReadCJCOffset Lib "TCPDAQ.dll" Alias "_TCP_ReadCJCOffset@8" _
                   (ByVal szIP As String, ByRef CJoffset As Double) As Long
Declare Function TCP_ReadCJCTemperature Lib "TCPDAQ.dll" Alias "_TCP_ReadCJCTemperature@8" _
                   (ByVal szIP As String, ByRef CJTemp As Double) As Long

'----------------------- TCP/IP MODBUS  ---------------------------------------------------------'
Declare Function TCP_MODBUS_ReadCoil Lib "TCPDAQ.dll" Alias "_TCP_MODBUS_ReadCoil@16" _
                   (ByVal szIP As String, ByVal wStartAddress As Integer, ByVal wCount As Integer, ByRef DATA As Byte) As Long
Declare Function TCP_MODBUS_WriteCoil Lib "TCPDAQ.dll" Alias "_TCP_MODBUS_WriteCoil@16" _
                   (ByVal szIP As String, ByVal wStartAddress As Integer, ByVal wCount As Integer, ByRef DATA As Byte) As Long
Declare Function TCP_MODBUS_ReadReg Lib "TCPDAQ.dll" Alias "_TCP_MODBUS_ReadReg@16" _
                   (ByVal szIP As String, ByVal wStartAddress As Integer, ByVal wCount As Integer, ByRef DATA As Integer) As Long
Declare Function TCP_MODBUS_WriteReg Lib "TCPDAQ.dll" Alias "_TCP_MODBUS_WriteReg@16" _
                   (ByVal szIP As String, ByVal wStartAddress As Integer, ByVal wCount As Integer, ByRef DATA As Integer) As Long

