//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#define DEFAULT_PORT 502

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TCPDAQLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnReadClick(TObject *Sender)
{
        int          i,j;
        int          ReturnValue;
        WORD         wStartAddress;
        WORD         wCount;
        short        wData[64];
        char         ch[80];
        AnsiString   s1;

        wStartAddress=StrToInt(edtStartAddress->Text);
        wCount=StrToInt(edtCount->Text);
        if( wCount<1 || wCount>64 )
        {
           sprintf(ch,"Register counts have to be between 1 to 64");
           MessageBox(NULL, ch, "Read Register demo", MB_OK+MB_ICONEXCLAMATION);
           return;
        }
        for(i=0; i<wCount; i++)
           wData[i]=0x1234;

        //--- GET register ---
        ReturnValue=TCPDAQ1->ModBusReadReg(wStartAddress, wCount, wData);
        if( ReturnValue<0 )
        {
           sprintf(ch,"Read Register Failure!, Error Code:%d",ReturnValue);
           MessageBox(NULL, ch, "Read Register demo", MB_OK+MB_ICONEXCLAMATION);
           return;
        }
        memoMsg->Lines->Clear();
        for(i=0,j=wStartAddress; i<wCount; i++,j++)
        {
           memoMsg->Lines->Add(s1.sprintf("Address:%d   Value:%04x[hex]   Value:%d",j,wData[i],wData[i]));
        }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
   TCPDAQ1->Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    if (Button1->Tag==0)
    {

        TCPDAQ1->ModuleIP=edtIPAddress->Text;
        TCPDAQ1->Open();
        if( TCPDAQ1->LastError!=0 )
        {
            return ; // Can not connect to destination IP//
        }

        char mID;

        //Get Module ID //
        edtDeviceID->Text= TCPDAQ1->ModuleIDNo;
        edtVersion->Text=TCPDAQ1->Version;
        Button1->Caption="Stop";
        btnRead->Enabled=true;
        Button1->Tag=1  ;
        mErrMsg->Text="No Error";
    }
    else
    {
        TCPDAQ1->Close();
        Button1->Tag=0;
        Button1->Caption="Start";
        btnRead->Enabled=false;

    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::TCPDAQ1Error(TObject *Sender, short ErrorCode,
      BSTR ErrorMsg)
{
   mErrMsg->Text=ErrorMsg; //Show Error message//
   Application->MessageBox((char *)mErrMsg->Text.c_str(), NULL, MB_OK);    
}
//---------------------------------------------------------------------------

