//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"

#define DEFAULT_PORT 502

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TCPDAQLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnWriteClick(TObject *Sender)
{
        int          i,j;
    //    int          ReturnValue,DLLVersion;
        WORD         wStartAddress;
        WORD         wCount;
        short         wData[64];
        char         ch[80];
        AnsiString   s1;
        TEdit        *pEdit;

         wStartAddress=StrToInt(edtStartAddress->Text);
        wCount=StrToInt(edtCount->Text);
        if( wCount<1 || wCount>16 )
        {
           sprintf(ch,"Register counts have to be between 1 to 16");
           MessageBox(NULL, ch, "Write registers demo", MB_OK+MB_ICONEXCLAMATION);
           return;
        }
        for(i=0; i<wCount; i++)
        {
           pEdit=(TEdit *)FindComponent("edtData"+IntToStr(i));
	       wData[i]=StrToInt("0x"+pEdit->Text);
        }
        //--- MODBUS  WriteReg ---
        TCPDAQ1->ModBusWriteReg( wStartAddress, wCount, wData);
 }
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    //------- Disconnect to EX-9000MTCP -------
    TCPDAQ1->Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    if (Button1->Tag==0)
    {

        TCPDAQ1->ModuleIP=edtIPAddress->Text;
        TCPDAQ1->Open();
        if( TCPDAQ1->LastError!=0 )
        {
            return ; // Can not connect to destination IP//
        }

        char mID;

        //Get Module ID //
        edtDeviceID->Text= TCPDAQ1->ModuleIDNo;
        edtVersion->Text=TCPDAQ1->Version;
        Button1->Caption="Stop";
        btnWrite->Enabled=true;
        Button1->Tag=1  ;
        mErrMsg->Text="No Error";
    }
    else
    {
        TCPDAQ1->Close();
        Button1->Tag=0;
        Button1->Caption="Start";
        btnWrite->Enabled=false;

    }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::TCPDAQ1Error(TObject *Sender, short ErrorCode,
      BSTR ErrorMsg)
{
    mErrMsg->Text=ErrorMsg; //Show Error message//
   Application->MessageBox((char *)mErrMsg->Text.c_str(), NULL, MB_OK);//IDYES);
}
//---------------------------------------------------------------------------

