//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"


#define DEFAULT_PORT 502
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TCPDAQLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
void __fastcall TForm1::btnReadClick(TObject *Sender)
{
        int          i,j,iChannel;
        double       fnValue[16],fmaxValue[16],fminValue[16],fAvgValue;
        int          iHAlarm[16],iLAlarm[16];
        char         ch[80];
        AnsiString   s1;
      //  int          tcp_err;

        iChannel = 8;
        for  (i=0;i<8;i++)
        {
            TCPDAQ1->AIChannelIndex=i;
            fnValue[i]=TCPDAQ1->AINormalValue;
            fmaxValue[i]=TCPDAQ1->AIMaximumValue;
            fminValue[i]=TCPDAQ1->AIMinimumValue;
            iHAlarm[i]=TCPDAQ1->AIHighAlarmStatus;
            iLAlarm[i]=TCPDAQ1->AILowAlarmStatus;

        }
        fAvgValue=TCPDAQ1->AIAverageValue;
        memoAIMsg->Lines->Clear();
        memoAIMsg->Lines->Add(s1.sprintf("Chn.  Normal  Maximum  Minmum  HiAlarm   LoAlarm"));
        for(i=0; i<iChannel; i++)
        {
           memoAIMsg->Lines->Add(s1.sprintf(" %d    %5.3f %5.3f  %5.3f    %d         %d",i,fnValue[i],fmaxValue[i],fminValue[i]
           ,iHAlarm[i],iLAlarm[i] ));
        }
        memoAIMsg->Lines->Add(s1.sprintf(" Avg  %5.3f",fAvgValue));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
    Close();
}

//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    TCPDAQ1->Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TCPDAQ1Error(TObject *Sender, short ErrorCode,
      BSTR ErrorMsg)
{
   mErrMsg->Text=ErrorMsg; //Show Error message//
   Application->MessageBox((char *)mErrMsg->Text.c_str(), NULL, MB_OK);//IDYES);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    if (Button1->Tag==0)
    {

        TCPDAQ1->ModuleIP=edtIPAddress->Text;
        TCPDAQ1->Open();
        if( TCPDAQ1->LastError!=0 )
        {
            return ; // Can not connect to destination IP//
        }

        char mID;

        //Get Module ID //
        edtDeviceID->Text= TCPDAQ1->ModuleIDNo;
        edtVersion->Text=TCPDAQ1->Version;
        Button1->Caption="Stop";
        btnRead->Enabled=true;
        Button1->Tag=1  ;
        mErrMsg->Text="No Error";
    }
    else
    {
        TCPDAQ1->Close();
        Button1->Tag=0;
        Button1->Caption="Start";
        btnRead->Enabled=false;

    }

}
//---------------------------------------------------------------------------

