//-------------------- demo ------------------------------------//

#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"

#define DEFAULT_PORT 502
#pragma package(smart_init)
#pragma link "TCPDAQLib_OCX"
#pragma resource "*.dfm"
TForm1 *Form1;
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}


void __fastcall TForm1::btnReadClick(TObject *Sender)
{
        int          i,j;
        BYTE         byDI[16];
        BYTE         byDO[16];
        long         lDIcount[16];
        char         ch[80];
        AnsiString   s1;

       	for(i=0; i<16; i++)
        {
            TCPDAQ1->DIChannelIndex=i;
            byDI[i]=TCPDAQ1->DIStatus;
            lDIcount[i]=TCPDAQ1->DICounterValue;

            TCPDAQ1->DOChannelIndex=i;
            byDO[i]=TCPDAQ1->DOStatus;
        }

        //----------------show--------------
        memoDIMsg->Lines->Clear();
       	for(i=0; i<16; i++)
        {
           if( byDI[i]==0xff )
              break;
           memoDIMsg->Lines->Add(s1.sprintf("DI:%d   Value:%d Counts:%d",i,byDI[i],lDIcount[i]));
        }
        memoDOMsg->Lines->Clear();
       	for(i=0; i<16; i++)
        {
           if( byDO[i]==0xff )
              break;
           memoDOMsg->Lines->Add(s1.sprintf("DO:%d   Value:%d",i,byDO[i]));
        }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
        //------- Disconnect to EX-9000MTCP -------
    TCPDAQ1->Close();
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
   if (Button1->Tag==0)
    {

        TCPDAQ1->ModuleIP=edtIPAddress->Text;
        TCPDAQ1->Open();
        if( TCPDAQ1->LastError!=0 )
        {
            return ; // Can not connect to destination IP//
        }

        char mID;

        //Get Module ID //
        edtDeviceID->Text= TCPDAQ1->ModuleIDNo;
        edtVersion->Text=TCPDAQ1->Version;
        Button1->Caption="Stop";
        btnRead->Enabled=true;
        Button1->Tag=1  ;
        mErrMsg->Text="No Error";
    }
    else
    {
        TCPDAQ1->Close();
        Button1->Tag=0;
        Button1->Caption="Start";
        btnRead->Enabled=false;

    }
}
//---------------------------------------------------------------------------

