// AlarmEventDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AlarmEvent.h"
#include "AlarmEventDlg.h"


UINT ThreadProc( LPVOID lpParam );

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char			szIPAddress[20];
static int		iTotalReceive;
static int		iTotalTimeout;
static int		iThreadIndex;
//----------------------------------------------
//struct _AlarmInfo   *pAlarmData,AlarmData;
//static BYTE byLoopFlag=1;
//HANDLE    hEvent;
/////////////////////////////////////////////////////////////////////////////
// CAlarmEventDlg dialog

CAlarmEventDlg::CAlarmEventDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAlarmEventDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAlarmEventDlg)
	m_strIPAddress = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAlarmEventDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAlarmEventDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAlarmEventDlg, CDialog)
	//{{AFX_MSG_MAP(CAlarmEventDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_STOP, OnStop)
	ON_BN_CLICKED(ID_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlarmEventDlg message handlers

BOOL CAlarmEventDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.15";
	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

   (CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAlarmEventDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAlarmEventDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAlarmEventDlg::OnExit()
{
    //--- Finally, calling TCP_Close() to release all allocated resource  ---
   m_tcpdaq.Close();
	CDialog::OnCancel();

}

void CAlarmEventDlg::OnStart()
{
   CString   strText,strTemp;


   // get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

	((CListBox*)GetDlgItem(IDC_LIST_STREAM))->ResetContent();

    //--- Starting to receive the streaming data come from EX-9000MTCP ---
   
   m_tcpdaq.SetModuleIP(szIPAddress);
   m_tcpdaq.SetEventTriggerEnable(TRUE);
   m_tcpdaq.Open();

    if(m_tcpdaq.GetLastError()<0 )
    {
      m_tcpdaq.SetEventTriggerEnable(FALSE);
      m_tcpdaq.Close();
      return;
    }

   SetDlgItemText(IDC_EDIT_DLLVER,m_tcpdaq.GetVersion());
	(CButton *)GetDlgItem(ID_START)->EnableWindow( FALSE );
	(CButton *)GetDlgItem(ID_STOP)->EnableWindow( TRUE );

}

void CAlarmEventDlg::OnStop()
{
 	// TODO: Add your control notification handler code here
   m_tcpdaq.SetEventTriggerEnable(FALSE);
   m_tcpdaq.Close();
	(CButton *)GetDlgItem(ID_START)->EnableWindow(TRUE );
	(CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );
}

BEGIN_EVENTSINK_MAP(CAlarmEventDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CAlarmEventDlg)
	ON_EVENT(CAlarmEventDlg, IDC_TCPDAQCTRL1, 1 /* EventDataArrival */, OnEventDataArrivalTcpdaqctrl1, VTS_BSTR VTS_I2 VTS_I2 VTS_I2 VTS_I2)
	ON_EVENT(CAlarmEventDlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CAlarmEventDlg::OnEventDataArrivalTcpdaqctrl1(LPCTSTR DateTime, short EventChannel, short EventType, short EventStatus, short EventValue) 
{
	// TODO: Add your control notification handler code here
   CString strText;

   strText.Format( "%s   %02d -%02d - %02d - %00004X",DateTime, EventChannel, EventType,EventStatus,EventValue);
   ((CListBox*)GetDlgItem(IDC_LIST_STREAM))->InsertString( -1, strText );
	
}

void CAlarmEventDlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
	MessageBox(ErrorMsg);

}
