// CoilReadDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CoilRead.h"
#include "CoilReadDlg.h"


#define DEFAULT_PORT	502  // Port for Modbus/TCP
//-------- default timeout ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoilReadDlg dialog

CCoilReadDlg::CCoilReadDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCoilReadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCoilReadDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_strNoOfRead = _T("1");
	m_strIPAddress = _T("192.168.0.50");
	m_strStartAddress = _T("1");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32

   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCoilReadDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCoilReadDlg)
	DDX_Text(pDX, IDC_EDIT_NOOFREAD, m_strNoOfRead);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCoilReadDlg, CDialog)
	//{{AFX_MSG_MAP(CCoilReadDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(ID_READCOIL, OnReadcoil)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoilReadDlg message handlers

BOOL CCoilReadDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

   //--- Firstly, initial DLL to working ---
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCoilReadDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCoilReadDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCoilReadDlg::OnExit()
{
	// TODO: Add your control notification handler code here
	m_tcpdaq.Close();
  	CDialog::OnOK();

}

void CCoilReadDlg::OnConnect()
{
	// TODO: Add your control notification handler code here
   char szIPAddress[16],szid[20];

   // get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

   m_tcpdaq.SetModuleIP(szIPAddress);
   m_tcpdaq.Open();

	((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->ResetContent();

   SetDlgItemText(IDC_EDIT_DLLVERSION,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   SetDlgItemText(IDC_EDIT_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);

	(CButton *)GetDlgItem(IDC_CONNECT)->EnableWindow( FALSE );
	(CButton *)GetDlgItem(ID_READREGISTER)->EnableWindow( TRUE );


}

BEGIN_EVENTSINK_MAP(CCoilReadDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CCoilReadDlg)
	ON_EVENT(CCoilReadDlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CCoilReadDlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg)
{
	// TODO: Add your control notification handler code here
	MessageBox(ErrorMsg);
}

void CCoilReadDlg::OnReadcoil() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	int       i,j;
   short      wStartAddress;
   short      wCount;
   short      wData[64];

	// How many registers to read
	GetDlgItemText(IDC_EDIT_NOOFREAD,strTemp);
	wCount=atoi(strTemp);

	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

 	if( wCount<1 || wCount>64  || wStartAddress <1)
	{
		MessageBox("The start address or number of Register must between 1 to 64 !");
		return;
	}

    //--- Reading the coils ---
    if( m_tcpdaq.ModBusReadCoil(wStartAddress,wCount,wData)!=0 )
       return;

	((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->ResetContent();
	for(i=0,j=wStartAddress; i<wCount; i++,j++)
	{
		strText.Format( "Address:%d   Value:%d ", j,wData[i]);
		((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->InsertString( -1, strText );
	}
	
}
