// coilwrDlg.cpp : implementation file
//

#include "stdafx.h"
#include "coilwr.h"
#include "coilwrDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DEFAULT_PORT 502  // Port for Modbus/TCP
//-------- default timeout ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

/////////////////////////////////////////////////////////////////////////////
// CCoilwrDlg dialog

CCoilwrDlg::CCoilwrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCoilwrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCoilwrDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_nStart0 = 1;
	m_nStart1 = 1;
	m_nStart2 = 1;
	m_nStart3 = 1;
	m_nStart4 = 1;
	m_nStart5 = 1;
	m_nStart6 = 1;
	m_nStart7 = 1;
	m_nStart8 = 1;
	m_nStart9 = 1;
	m_nStart10 = 1;
	m_nStart11 = 1;
	m_nStart12 = 1;
	m_nStart13 = 1;
	m_nStart14 = 1;
	m_nStart15 = 1;
	m_strIPAddress = _T("192.168.0.50");
	m_strNoOfWrite = _T("8");
	m_strStartAddress = _T("17");
	m_strDeviceID = _T("");
	m_strDLLVersion = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCoilwrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCoilwrDlg)
	DDX_Radio(pDX, IDC_RADIO1, m_nStart0);
	DDX_Radio(pDX, IDC_RADIO3, m_nStart1);
	DDX_Radio(pDX, IDC_RADIO5, m_nStart2);
	DDX_Radio(pDX, IDC_RADIO7, m_nStart3);
	DDX_Radio(pDX, IDC_RADIO9, m_nStart4);
	DDX_Radio(pDX, IDC_RADIO11, m_nStart5);
	DDX_Radio(pDX, IDC_RADIO13, m_nStart6);
	DDX_Radio(pDX, IDC_RADIO15, m_nStart7);
	DDX_Radio(pDX, IDC_RADIO17, m_nStart8);
	DDX_Radio(pDX, IDC_RADIO19, m_nStart9);
	DDX_Radio(pDX, IDC_RADIO21, m_nStart10);
	DDX_Radio(pDX, IDC_RADIO23, m_nStart11);
	DDX_Radio(pDX, IDC_RADIO25, m_nStart12);
	DDX_Radio(pDX, IDC_RADIO27, m_nStart13);
	DDX_Radio(pDX, IDC_RADIO29, m_nStart14);
	DDX_Radio(pDX, IDC_RADIO31, m_nStart15);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_NOOFWRITE, m_strNoOfWrite);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
	DDX_Text(pDX, IDC_EDIT_DLLVERSION, m_strDLLVersion);
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCoilwrDlg, CDialog)
	//{{AFX_MSG_MAP(CCoilwrDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_WRITECOIL, OnWritecoil)
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoilwrDlg message handlers

BOOL CCoilwrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCoilwrDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCoilwrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCoilwrDlg::OnWritecoil() 
{
	// TODO: Add your control notification handler code here
   CString     strText,strTemp;
	int         i,nID;
   short       wStartAddress;
   short       wCount;
   short       byData[128];  
	int         CoilValue[16];
	CButton*    pRadioButton;
 
   nID=IDC_RADIO1;
	for(i=0; i<16; i++)
	{
	   pRadioButton=(CButton *)GetDlgItem(nID+2*i);
		if( pRadioButton->GetCheck()==BST_CHECKED )
			CoilValue[i]=0;
		else
			CoilValue[i]=1;
	}

	// How many coils to write
	GetDlgItemText(IDC_EDIT_NOOFWRITE,strTemp);
	wCount=atoi(strTemp);
	if( wCount<1 || wCount>16 )
	{
		MessageBox("The # of Coil must between 1 to 16 !");
		return;
	}

	//Start address to write
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

    //--- Set data to write to coil's registers ---
	for(i=0; i<wCount; i++)
		byData[i]=CoilValue[i];

   //--- Writing  to coil's registers ---
   if (m_tcpdaq.ModBusWriteCoil(wStartAddress,wCount,byData)!=0)
    {
        return;
    }
}

void CCoilwrDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
   m_tcpdaq.Close();
   CDialog::OnOK();

}

void CCoilwrDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
   char szIPAddress[16],szid[20];

   // Get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

   m_tcpdaq.SetModuleIP(szIPAddress);
   m_tcpdaq.Open();

   if (m_tcpdaq.GetLastError()!=0)
      return;

   //-- Get Activex Control Version --//
   SetDlgItemText(IDC_EDIT_DLLVERSION,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   SetDlgItemText(IDC_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);

	(CButton *)GetDlgItem(IDC_CONNECT)->EnableWindow( FALSE );
	(CButton *)GetDlgItem(ID_WRITECOIL)->EnableWindow( TRUE );
	
}

BEGIN_EVENTSINK_MAP(CCoilwrDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CCoilwrDlg)
	ON_EVENT(CCoilwrDlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CCoilwrDlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
	MessageBox(ErrorMsg);
}
