// RegWriteDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RegWrite.h"
#include "RegWriteDlg.h"

#define DEFAULT_PORT 502   // Modbus/TCP's Port


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegWriteDlg dialog

CRegWriteDlg::CRegWriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegWriteDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegWriteDlg)
	m_strData0 = _T("255");
	m_strData1 = _T("255");
	m_strData2 = _T("255");
	m_strData3 = _T("255");
	m_strData4 = _T("255");
	m_strData5 = _T("255");
	m_strData6 = _T("255");
	m_strData7 = _T("255");
	m_strData8 = _T("255");
	m_strData9 = _T("255");
	m_strData10 = _T("255");
	m_strData11 = _T("255");
	m_strData12 = _T("255");
	m_strData13 = _T("255");
	m_strData14 = _T("255");
	m_strData15 = _T("255");
	m_strIPAddress = _T("192.168.0.15");
	m_strNoOfWrite = _T("1");
	m_strStartAddress = _T("1");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}
CRegWriteDlg::~CRegWriteDlg()
{
    // finally, release some resource allocated by DLL
}


void CRegWriteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegWriteDlg)
	DDX_Text(pDX, IDC_DATA0, m_strData0);
	DDX_Text(pDX, IDC_DATA1, m_strData1);
	DDX_Text(pDX, IDC_DATA2, m_strData2);
	DDX_Text(pDX, IDC_DATA3, m_strData3);
	DDX_Text(pDX, IDC_DATA4, m_strData4);
	DDX_Text(pDX, IDC_DATA5, m_strData5);
	DDX_Text(pDX, IDC_DATA6, m_strData6);
	DDX_Text(pDX, IDC_DATA7, m_strData7);
	DDX_Text(pDX, IDC_DATA8, m_strData8);
	DDX_Text(pDX, IDC_DATA9, m_strData9);
	DDX_Text(pDX, IDC_DATA10, m_strData10);
	DDX_Text(pDX, IDC_DATA11, m_strData11);
	DDX_Text(pDX, IDC_DATA12, m_strData12);
	DDX_Text(pDX, IDC_DATA13, m_strData13);
	DDX_Text(pDX, IDC_DATA14, m_strData14);
	DDX_Text(pDX, IDC_DATA15, m_strData15);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_NOOFWRITE, m_strNoOfWrite);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegWriteDlg, CDialog)
	//{{AFX_MSG_MAP(CRegWriteDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_WRITEREGISTER, OnWriteregister)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegWriteDlg message handlers

BOOL CRegWriteDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRegWriteDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRegWriteDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CRegWriteDlg::OnWriteregister() 
{
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	char      szTemp[10],*stopstring;
	int       i,nID;
	short      wStartAddress;
   short      wCount;
   short      wData[64];  

	// Number of registers to write
	GetDlgItemText(IDC_EDIT_NOOFWRITE,strTemp);
	wCount=atoi(strTemp);
	if( wCount<0 || wCount>16 )
	{
		MessageBox("The # of register must between 1 to 16 !");
		return;
	}

	//--- Start address to write ---
	//--- Notice: the address start at 1 instead of 40001
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

	if( wStartAddress<=0)
	{
		MessageBox("The start address of register must be great than 0 !");
		return;
	}

   //--- Set the data for writing to EX-9000MTCP ---
	nID=IDC_DATA0;
	for(i=0; i<16; i++)
	{
		GetDlgItemText(nID+i,strTemp);
		strcpy(szTemp,strTemp.GetBuffer(10));
		wData[i]=(WORD)strtol(szTemp, &stopstring, 16);
	}
    
	//------ Writng the registers ------
    m_tcpdaq.ModBusWriteReg(wStartAddress,wCount,wData);
}

void CRegWriteDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	
   m_tcpdaq.Close();
   CDialog::OnCancel();

}

void CRegWriteDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
   char  szid[80];
   int tcp_err;

   SetDlgItemText(IDC_ERRORCODE, "");

   //create a connection to EX-9000MTCP ---
   GetDlgItemText(IDC_EDIT_IPADDRESS,szid,20);
   m_tcpdaq.SetModuleIP(szid);
   
   m_tcpdaq.Open();
   if( (tcp_err=m_tcpdaq.GetLastError())<0 )
      return;

   SetDlgItemText(IDC_EDIT_OCXVERSION,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   SetDlgItemText(IDC_EDIT_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);

   SetDlgItemText(IDC_ERRORCODE, "0");
	(CButton *)GetDlgItem(ID_WRITEREGISTER)->EnableWindow( TRUE );
	(CButton *)GetDlgItem(IDC_CONNECT)->EnableWindow( FALSE );
	
}

BEGIN_EVENTSINK_MAP(CRegWriteDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CRegWriteDlg)
	ON_EVENT(CRegWriteDlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CRegWriteDlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
   char sz[20];
   
   _itoa(ErrorCode,sz,10);
	SetDlgItemText(IDC_ERRORCODE, sz);
   MessageBox(ErrorMsg);
}
