// ReadAIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReadAI.h"
#include "ReadAIDlg.h"
#include <winsock2.h>
//#include "..\..\..\include\TCPDAQ.H"

#define DEFAULT_PORT 502   // Modbus/TCP's Port

//-------- Set timeout value ------
//int      iConnectionTimeout=2000;
//int      iSendTimeout=2000;
//int      iReceiveTimeout=2000;
int      AI_chns=0;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMyReadAIDlg dialog

CMyReadAIDlg::CMyReadAIDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMyReadAIDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMyReadAIDlg)
      // NOTE: the ClassWizard will add member initialization here
   m_strIPAddress = _T("");
   //}}AFX_DATA_INIT
   // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyReadAIDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
 //  DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
   DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
   //{{AFX_DATA_MAP(CMyReadAIDlg)
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyReadAIDlg, CDialog)
   //{{AFX_MSG_MAP(CMyReadAIDlg)
   ON_WM_PAINT()
   ON_WM_QUERYDRAGICON()
   ON_BN_CLICKED(ID_EXIT, OnExit)
   ON_BN_CLICKED(ID_ReadAI, OnReadAI)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_CLEARMAX, OnClearmax)
	ON_BN_CLICKED(IDC_CLEARMIN, OnClearmin)
	ON_BN_CLICKED(IDC_CLEARHIGH, OnClearhigh)
	ON_BN_CLICKED(IDC_CLEARLOW, OnClearlow)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyReadAIDlg message handlers

BOOL CMyReadAIDlg::OnInitDialog()
{

   CDialog::OnInitDialog();

   // Set the icon for this dialog.  The framework does this automatically
   //  when the application's main window is not a dialog
   SetIcon(m_hIcon, TRUE);       // Set big icon
   SetIcon(m_hIcon, FALSE);      // Set small icon

   // TODO: Add extra initialization here
   m_strIPAddress="192.168.0.17";
   SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

   return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyReadAIDlg::OnPaint()
{
   if (IsIconic())
   {
      CPaintDC dc(this); // device context for painting

      SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

      // Center icon in client rectangle
      int cxIcon = GetSystemMetrics(SM_CXICON);
      int cyIcon = GetSystemMetrics(SM_CYICON);
      CRect rect;
      GetClientRect(&rect);
      int x = (rect.Width() - cxIcon + 1) / 2;
      int y = (rect.Height() - cyIcon + 1) / 2;

      // Draw the icon
      dc.DrawIcon(x, y, m_hIcon);
   }
   else
   {
      CDialog::OnPaint();
   }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyReadAIDlg::OnQueryDragIcon()
{
   return (HCURSOR) m_hIcon;
}
void CMyReadAIDlg::OnExit()
{
   
   //--- Finally, release some resource that TCPDAQ Activex allocated---
   m_tcpdaq.Close();
   CDialog::OnCancel();
}

void CMyReadAIDlg::OnReadAI()
{
   // TODO: Add your control notification handler code here
   CString   strText,strTemp;
   int       i;

   ((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->ResetContent();

   strText="ChnNo    Normal     Maximum       Minimum      Hi_Alarm  Lo_Alarm";
   ((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->InsertString( -1, strText );

   for (i=0;i<AI_chns;i++)
   {
      m_tcpdaq.SetAIChannelIndex(i);

      strText.Format("  %d           %7.3f     %7.3f           %7.3f            %d               %d", i,
                 m_tcpdaq.GetAINormalValue(), 
                 m_tcpdaq.GetAIMaximumValue(),
                 m_tcpdaq.GetAIMinimumValue(),
                 m_tcpdaq.GetAIHighAlarmStatus(),
                 m_tcpdaq.GetAILowAlarmStatus()  );


      ((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->InsertString( -1, strText );
   }
   
       strText.Format( "  Avg      %7.3f", m_tcpdaq.GetAIAverageValue());
   ((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->InsertString( -1, strText );

}

void CMyReadAIDlg::OnStart() 
{
	// TODO: Add your control notification handler code here
   char  szid[80];
   int iNo,tcp_err;


   SetDlgItemText(IDC_ERRORMSG, "");
   SetDlgItemText(IDC_ERRORCODE, "");

   //create a connection to EX-9000MTCP ---
   GetDlgItemText(IDC_EDIT_IPADDRESS,szid,20);
   m_tcpdaq.SetModuleIP(szid);
   
   m_tcpdaq.Open();
   if( (tcp_err=m_tcpdaq.GetLastError())<0 )
      return;

   SetDlgItemText(IDC_EDIT_DLLVER,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   iNo=atoi(m_tcpdaq.GetModuleName());
   SetDlgItemText(IDC_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);


   switch (iNo)
   {
      case 9017:     // The connected module name is EX-9017//

         AI_chns=8;  // EX-9017 has 8 analog input channels//

         break;
      case 9019:     // The connected module name is EX-9019//

         AI_chns=8;  // EX-9019 has 8 analog input channels//

         break;
      case 9015:     // The connected module name is EX-9015//

         AI_chns=7;  // EX-9015 has 7 analog input channels//

         break;
      default:
         AI_chns=0;  // Not analog module//
   }

   SetDlgItemText(IDC_ERRORMSG, "Connected");
   SetDlgItemText(IDC_ERRORCODE, "0");


}

BEGIN_EVENTSINK_MAP(CMyReadAIDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CMyReadAIDlg)
	ON_EVENT(CMyReadAIDlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CMyReadAIDlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
 
   char sz[10];

   MessageBox(ErrorMsg);
   _itoa( ErrorCode,sz,10);
   SetDlgItemText(IDC_ERRORMSG, ErrorMsg);
   SetDlgItemText(IDC_ERRORCODE, sz);

}

void CMyReadAIDlg::OnClearmax() 
{
   int i;
	// TODO: Add your control notification handler code here
   for (i=0;i<AI_chns;i++)
   {
      m_tcpdaq.SetAIChannelIndex(i);
      m_tcpdaq.SetAIMaximumValue(0);
   }
}

void CMyReadAIDlg::OnClearmin() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<AI_chns;i++)
   {
      m_tcpdaq.SetAIChannelIndex(i);
      m_tcpdaq.SetAIMinimumValue(0);
   }

}

void CMyReadAIDlg::OnClearhigh() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<AI_chns;i++)
   {
      m_tcpdaq.SetAIChannelIndex(i);
      m_tcpdaq.SetAIHighAlarmStatus(0);
   }
	
}

void CMyReadAIDlg::OnClearlow() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<AI_chns;i++)
   {
      m_tcpdaq.SetAIChannelIndex(i);
      m_tcpdaq.SetAILowAlarmStatus(0);
   }
	
}
