// ReadDIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReadDIO.h"
#include "ReadDIODlg.h"
#include <winsock2.h>

#define DEFAULT_PORT 502   // Modbus/TCP's Port

//-------- Set timeout value ------
int      iConnectionTimeout=2000;
int      iSendTimeout=2000;
int      iReceiveTimeout=2000;
int      DO_chns=0,DI_chns=0;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMyReadDIODlg dialog

CMyReadDIODlg::CMyReadDIODlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMyReadDIODlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMyReadDIODlg)
      // NOTE: the ClassWizard will add member initialization here
   m_strIPAddress = _T("");
   //}}AFX_DATA_INIT
   // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyReadDIODlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
 //  DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
   DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
   //{{AFX_DATA_MAP(CMyReadDIODlg)
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyReadDIODlg, CDialog)
   //{{AFX_MSG_MAP(CMyReadDIODlg)
   ON_WM_PAINT()
   ON_WM_QUERYDRAGICON()
   ON_BN_CLICKED(ID_EXIT, OnExit)
   ON_BN_CLICKED(ID_READDIO, OnReaddio)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_CLEARLATCH, OnClearlatch)
	ON_BN_CLICKED(IDC_CLEARCOUNT, OnClearcount)
	ON_BN_CLICKED(IDC_STARTCOUNT, OnStartcount)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyReadDIODlg message handlers

BOOL CMyReadDIODlg::OnInitDialog()
{

   CDialog::OnInitDialog();

   // Set the icon for this dialog.  The framework does this automatically
   //  when the application's main window is not a dialog
   SetIcon(m_hIcon, TRUE);       // Set big icon
   SetIcon(m_hIcon, FALSE);      // Set small icon

   // TODO: Add extra initialization here
   m_strIPAddress="192.168.0.52";
   SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

    //Initial DLL to working ---
   return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyReadDIODlg::OnPaint()
{
   if (IsIconic())
   {
      CPaintDC dc(this); // device context for painting

      SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

      // Center icon in client rectangle
      int cxIcon = GetSystemMetrics(SM_CXICON);
      int cyIcon = GetSystemMetrics(SM_CYICON);
      CRect rect;
      GetClientRect(&rect);
      int x = (rect.Width() - cxIcon + 1) / 2;
      int y = (rect.Height() - cyIcon + 1) / 2;

      // Draw the icon
      dc.DrawIcon(x, y, m_hIcon);
   }
   else
   {
      CDialog::OnPaint();
   }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyReadDIODlg::OnQueryDragIcon()
{
   return (HCURSOR) m_hIcon;
}
void CMyReadDIODlg::OnExit()
{
   
   //--- Finally, release some resource that TCPDAQ Activex allocated---
   m_tcpdaq.Close();
   CDialog::OnCancel();
}

void CMyReadDIODlg::OnReaddio()
{
   // TODO: Add your control notification handler code here
   CString   strText,strTemp;
   int       i;
   BYTE      byDI[16], byLatch[16],byDO[16];
   long      lyCount[16];

   for (i=0;i<DI_chns;i++)
   {
      m_tcpdaq.SetDIChannelIndex(i);
      byDI[i]=(BYTE)m_tcpdaq.GetDIStatus();
      byLatch[i]=(BYTE)m_tcpdaq.GetDILatchStatus();
      lyCount[i]=m_tcpdaq.GetDICounterValue();
   }

   for (i=0;i<DO_chns;i++)
   {
      m_tcpdaq.SetDIChannelIndex(i);
      byDO[i]=(BYTE)m_tcpdaq.GetDOStatus();
   }

   //show the DI value
   ((CListBox*)GetDlgItem(IDC_LIST_DIVALUE))->ResetContent();
   strText.Format( "ChNo     Status    Latch      Counts");
   ((CListBox*)GetDlgItem(IDC_LIST_DIVALUE))->InsertString( -1, strText );

   for(i=0; i<DI_chns ; i++)
   { 
      strText.Format( "  %02d         %d            %d            %d ", i,byDI[i]  ,byLatch[i],lyCount[i]);
      ((CListBox*)GetDlgItem(IDC_LIST_DIVALUE))->InsertString( -1, strText );
   }
   //show the DO value
   ((CListBox*)GetDlgItem(IDC_LIST_DOVALUE))->ResetContent();
   strText.Format( "ChNo     Status");
   ((CListBox*)GetDlgItem(IDC_LIST_DOVALUE))->InsertString( -1, strText );

   for(i=0; i<DO_chns; i++)
   {
      strText.Format( "  %02d         %d ", i,byDO[i]);
      ((CListBox*)GetDlgItem(IDC_LIST_DOVALUE))->InsertString( -1, strText );
   }
}

void CMyReadDIODlg::OnStart() 
{
	// TODO: Add your control notification handler code here
   char  szid[80];
   int iNo,tcp_err;


   SetDlgItemText(IDC_ERRORMSG, "");
   SetDlgItemText(IDC_ERRORCODE, "");

   //create a connection to EX-9000MTCP ---
   GetDlgItemText(IDC_EDIT_IPADDRESS,szid,20);
   m_tcpdaq.SetModuleIP(szid);
   
   m_tcpdaq.Open();
   if( (tcp_err=m_tcpdaq.GetLastError())<0 )
      return;

   SetDlgItemText(IDC_EDIT_DLLVER,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   iNo=atoi(m_tcpdaq.GetModuleName());
   SetDlgItemText(IDC_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);


   switch (iNo)
   {
      case 9050:     // The connected module name is EX-9050//

         DI_chns=12; // EX-9050 has 12 digital input channels//
         DO_chns=6;  // EX-9050 has 6 digital output channels//
         break;

      case 9051:     // The connected module name is EX-9051//

         DI_chns=12; // EX-9051 has 12 digital input channels//
         DO_chns=2;  // EX-9051 has 2 digital output channels//
         break;

      case 9052:     // The connected module name is EX-9052//

         DI_chns=8;  // EX-9052 has 8 digital input channels//
         DO_chns=8;  // EX-9052 has 8 digital output channels//
         break;

      case 9017:     // The connected module name is EX-9017//

         DI_chns=0;  // EX-9017 has no digital input channels//
         DO_chns=2;  // EX-9017 has 2 digital output channels//
         break;

       case 9019:    // The connected module name is EX-9019//

         DI_chns=0;  // EX-9019 has no digital input channels//
         DO_chns=2;  // EX-9019 has 2 digital output channels//
         break;

       default:
         DI_chns=0;  // Others has no digital input channels//
         DO_chns=0;  // Others has no digital output channels//

  }

   SetDlgItemText(IDC_ERRORMSG, "Connected");
   SetDlgItemText(IDC_ERRORCODE, "0");
}

BEGIN_EVENTSINK_MAP(CMyReadDIODlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CMyReadDIODlg)
	ON_EVENT(CMyReadDIODlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CMyReadDIODlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
 
   char sz[10];

   MessageBox(ErrorMsg);
   _itoa( ErrorCode,sz,10);
   SetDlgItemText(IDC_ERRORMSG, ErrorMsg);
   SetDlgItemText(IDC_ERRORCODE, sz);
}

void CMyReadDIODlg::OnClearlatch() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<DI_chns;i++)
   {
      m_tcpdaq.SetDIChannelIndex(i);
      m_tcpdaq.SetDILatchStatus(0);
   }
}

void CMyReadDIODlg::OnClearcount() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<DI_chns;i++)
   {
      m_tcpdaq.SetDIChannelIndex(i);
      m_tcpdaq.SetDICounterValue(0);
   }
}

void CMyReadDIODlg::OnStartcount() 
{
	// TODO: Add your control notification handler code here
   int i;
   for (i=0;i<DI_chns;i++)
   {
      m_tcpdaq.SetDIChannelIndex(i);
      m_tcpdaq.SetDIStartCount(TRUE);
   }
}
