// SetDODlg.cpp : implementation file
//

#include "stdafx.h"
#include "SetDO.h"
#include "SetDODlg.h"
#include <winsock2.h>
//#include "..\..\..\include\TCPDAQ.H"

#define DEFAULT_PORT 502   // Modbus/TCP's Port

//-------- Set timeout value ------
int      DO_chns=0;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMySetDODlg dialog

CMySetDODlg::CMySetDODlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMySetDODlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMySetDODlg)
      // NOTE: the ClassWizard will add member initialization here
   m_strIPAddress = _T("");
   //}}AFX_DATA_INIT
   // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMySetDODlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
 //  DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
   DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
   //{{AFX_DATA_MAP(CMySetDODlg)
	DDX_Control(pDX, IDC_TCPDAQCTRL1, m_tcpdaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMySetDODlg, CDialog)
   //{{AFX_MSG_MAP(CMySetDODlg)
   ON_WM_PAINT()
   ON_WM_QUERYDRAGICON()
   ON_BN_CLICKED(ID_EXIT, OnExit)
   ON_BN_CLICKED(ID_SetDO, OnSetDO)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_SETDO, OnSetDO)
	ON_BN_CLICKED(IDC_SETCOUNT, OnSetcount)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMySetDODlg message handlers

BOOL CMySetDODlg::OnInitDialog()
{

   CDialog::OnInitDialog();

   // Set the icon for this dialog.  The framework does this automatically
   //  when the application's main window is not a dialog
   SetIcon(m_hIcon, TRUE);       // Set big icon
   SetIcon(m_hIcon, FALSE);      // Set small icon

   // TODO: Add extra initialization here
   m_strIPAddress="192.168.0.50";
   SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

    //Initial DLL to working ---
   return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMySetDODlg::OnPaint()
{
   if (IsIconic())
   {
      CPaintDC dc(this); // device context for painting

      SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

      // Center icon in client rectangle
      int cxIcon = GetSystemMetrics(SM_CXICON);
      int cyIcon = GetSystemMetrics(SM_CYICON);
      CRect rect;
      GetClientRect(&rect);
      int x = (rect.Width() - cxIcon + 1) / 2;
      int y = (rect.Height() - cyIcon + 1) / 2;

      // Draw the icon
      dc.DrawIcon(x, y, m_hIcon);
   }
   else
   {
      CDialog::OnPaint();
   }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMySetDODlg::OnQueryDragIcon()
{
   return (HCURSOR) m_hIcon;
}
void CMySetDODlg::OnExit()
{
   
   //--- Finally, release some resource that TCPDAQ Activex allocated---
   m_tcpdaq.Close();
   CDialog::OnCancel();
}

int nid[8]={IDC_DO0,IDC_DO1,IDC_DO2,IDC_DO3,IDC_DO4,IDC_DO5,IDC_DO6,IDC_DO7};
int nidc[8]={IDC_COUNT0,IDC_COUNT1,IDC_COUNT2,IDC_COUNT3,IDC_COUNT4,IDC_COUNT5,IDC_COUNT6,IDC_COUNT7};

void CMySetDODlg::OnSetDO()
{

	// TODO: Add your control notification handler code here
	int       DOValue,i;
	CButton*  pRadioButton;

	for(i=0; i<DO_chns; i++)
	{
	  
      pRadioButton=(CButton *)GetDlgItem(nid[i]);
		if( pRadioButton->GetCheck()==BST_CHECKED )
			DOValue=1;
		else
			DOValue=0;
      m_tcpdaq.SetDOChannelIndex(i);
      m_tcpdaq.SetDOStatus(DOValue);
   }

}


void CMySetDODlg::OnStart() 
{
	// TODO: Add your control notification handler code here
   char  szid[80],Countstr[20];
   int iNo,tcp_err;
	CButton*  pRadioButton;
   int i;



   SetDlgItemText(IDC_ERRORMSG, "");
   SetDlgItemText(IDC_ERRORCODE, "");

   //create a connection to EX-9000MTCP ---
   GetDlgItemText(IDC_EDIT_IPADDRESS,szid,20);
   m_tcpdaq.SetModuleIP(szid);
   
   m_tcpdaq.Open();
   if( (tcp_err=m_tcpdaq.GetLastError())<0 )
      return;

   SetDlgItemText(IDC_EDIT_DLLVER,m_tcpdaq.GetVersion());

   //-- Get Module name ---//
   iNo=atoi(m_tcpdaq.GetModuleName());
   SetDlgItemText(IDC_NAME, m_tcpdaq.GetModuleName());

   //-- Get Id number ---//
   sprintf (szid,"%d",m_tcpdaq.GetModuleIDNo());
   SetDlgItemText(IDC_EDIT_DEVICEID, szid);



   switch (iNo)
   {
      case 9050:     // The connected module name is EX-9050//

         DO_chns=6;  // EX-9050 has 6 digital output channels//
         break;

      case 9051:     // The connected module name is EX-9051//

         DO_chns=2;  // EX-9051 has 2 digital output channels//
         break;

      case 9052:     // The connected module name is EX-9052//

         DO_chns=8;  // EX-9052 has 8 digital output channels//
         break;

      case 9017:     // The connected module name is EX-9017//

         DO_chns=2;  // EX-9017 has 2 digital output channels//
         break;

       case 9019:    // The connected module name is EX-9019//

         DO_chns=2;  // EX-9019 has 2 digital output channels//
         break;

       default:
         DO_chns=0;  // Others has no digital output channels//

  }
	for(i=0; i<DO_chns; i++)
	{
	  
      m_tcpdaq.SetDOChannelIndex(i);
      pRadioButton=(CButton *)GetDlgItem(nid[i]);
		pRadioButton->SetCheck(m_tcpdaq.GetDOStatus());
      sprintf (Countstr,"%d",m_tcpdaq.GetDOCounts());
      SetDlgItemText(nidc[i], Countstr);

   }

   SetDlgItemText(IDC_ERRORMSG, "Connected");
   SetDlgItemText(IDC_ERRORCODE, "0");
}

BEGIN_EVENTSINK_MAP(CMySetDODlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CMySetDODlg)
	ON_EVENT(CMySetDODlg, IDC_TCPDAQCTRL1, 2 /* OnError */, OnOnErrorTcpdaqctrl1, VTS_I2 VTS_BSTR)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CMySetDODlg::OnOnErrorTcpdaqctrl1(short ErrorCode, LPCTSTR ErrorMsg) 
{
	// TODO: Add your control notification handler code here
 
   char sz[10];

   MessageBox(ErrorMsg);
   _itoa( ErrorCode,sz,10);
   SetDlgItemText(IDC_ERRORMSG, ErrorMsg);
   SetDlgItemText(IDC_ERRORCODE, sz);
}

void CMySetDODlg::OnSetcount() 
{
   char sz[20];
   int i;
	// TODO: Add your control notification handler code here
	for(i=0; i<DO_chns; i++)
	{
	  
      m_tcpdaq.SetDOChannelIndex(i);
      GetDlgItemText(nidc[i],sz,20);
      m_tcpdaq.SetDOCounts(atol(sz));
   }

	
}
