//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtVersion: TEdit;
    Label2: TLabel;
    edtIPAddress2: TEdit;
    Label3: TLabel;
    memoMsg2: TMemo;
    btnExit: TButton;
    btnStart: TButton;
    btnStop: TButton;
    TCPDAQ1: TTCPDAQ;
    TCPDAQ2: TTCPDAQ;
    procedure btnExitClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
    procedure TCPDAQ1EventDataArrival(Sender: TObject;
      const DateTime: WideString; EventChannel, EventType, EventStatus,
      EventValue: Smallint);
    procedure TCPDAQ2Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
    procedure TCPDAQ2EventDataArrival(Sender: TObject;
      const DateTime: WideString; EventChannel, EventType, EventStatus,
      EventValue: Smallint);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin
//   TCPDAQ1.EventTriggerEnable:=false;
 //  TCPDAQ2.EventTriggerEnable:=false;
   TCPDAQ1.Close();
   TCPDAQ2.Close();
   close();
end;

procedure TForm1.btnStartClick(Sender: TObject);

begin

   btnStart.Enabled:=false;
   btnStop.Enabled:=true;

   //-----  create a event ---------------
  //hEvent := CreateEvent(NIL,FALSE,FALSE,NIL);


   //--- adding the first Event ----
   TCPDAQ1.ModuleIP:= edtIPAddress.Text;
   TCPDAQ2.ModuleIP:= edtIPAddress2.Text;

   TCPDAQ1.EventTriggerEnable:=true;
   TCPDAQ2.EventTriggerEnable:=true;

   TCPDAQ1.Open();
   TCPDAQ2.Open();


   memoMsg.Lines.Clear();
   memoMsg2.Lines.Clear();

end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
   
  btnStart.Enabled:=true;
  btnStop.Enabled:=false;

  TCPDAQ1.Close();
  TCPDAQ2.Close();

end;
procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
  ShowMessage(ErrorMsg );


end;

procedure TForm1.TCPDAQ1EventDataArrival(Sender: TObject;
  const DateTime: WideString; EventChannel, EventType, EventStatus,
  EventValue: Smallint);
begin
memoMsg.Lines.Add  (DateTime +' '+  IntToStr(   EventChannel))   ;

end;

procedure TForm1.TCPDAQ2Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
       ShowMessage(ErrorMsg );

end;

procedure TForm1.TCPDAQ2EventDataArrival(Sender: TObject;
  const DateTime: WideString; EventChannel, EventType, EventStatus,
  EventValue: Smallint);
begin
     memoMsg2.Lines.Add  (DateTime +' '+  IntToStr(   EventChannel))   ;
end;

end.
