//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    Label5: TLabel;
    Label4: TLabel;
    edtID: TEdit;
    Label6: TLabel;
    btnRead: TButton;
    btnExit: TButton;
    edtVersion: TEdit;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    mName: TEdit;
    Label7: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.btnExitClick(Sender: TObject);
begin

  TCPDAQ1.Close();
  close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   byData           : Array [0..127] of Smallint ;

   begin

        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        
        if ( (wCount<1) or (wCount>128) ) then
        begin
           ShowMessage('No. have to between 1 to 128');
           exit;
        end;
        
        //--- TCP_MODBUS_ReadCoil---
        TCPDAQ1.ModBusReadCoil(wStartAddress, wCount, byData[0]);

        memoMsg.Lines.Clear();
        j := wStartAddress;
     	for i:=0 to wCount -1 do
        begin
           memoMsg.Lines.Add('Address:' + IntToStr(j)+ '  Value:' + IntToStr(byData[i]) );
           inc( j );
        end;

end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);   // Error Event triggered by TCPDAQ driver//
begin
     ShowMessage(ErrorMsg );
end;

procedure TForm1.Button1Click(Sender: TObject);
begin

    if (Button1.Tag=0) then      // Start to Connect//
    begin

        TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
        TCPDAQ1.Open();   // Activate TCPDAQ driver //

        if TCPDAQ1.LastError<>0 then
        begin
           exit;        // Can not Connect to remote IP //
        end;
        Button1.Tag:=1;
        Button1.Caption:='Stop';
        //--- Get module name --
        mName.Text := TCPDAQ1.ModuleName;
        //--- Get module Id number --
        edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
        //--- Get AvtiveX Version --
        edtVersion.Text:=TCPDAQ1.Version;
        btnRead.Enabled:=true;

    end
    else
        begin
        Button1.Tag:=0;
        Button1.Caption:='Start';
        btnRead.Enabled:=false;
        TCPDAQ1.Close();
        end;
 end;
end.
