//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtID: TEdit;
    Label4: TLabel;
    btnRead: TButton;
    btnExit: TButton;
    edtVersion: TEdit;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    mName: TEdit;
    Label7: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}


procedure TForm1.btnExitClick(Sender: TObject);
begin

    //------- Disconnect to EX-9000 -------
    TCPDAQ1.Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i,j              : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   wData            : Array [0..63] of Smallint;

begin
        //--- Read Register ---//
        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        if ( (wCount<1) or (wCount>64) ) then
        begin
           ShowMessage('No. have to between 1 to 64');
           exit;
        end;

        for i := 0 to wCount - 1 do
           wData[i] := $1234;

        TCPDAQ1.ModBusReadReg(wStartAddress, wCount, wData[0]);
        if ( TCPDAQ1.LastError<> 0 ) then
        begin
           exit;
        end;

        memoMsg.Lines.Clear();
        j := wStartAddress;
        for i:=0 to wCount -1 do
        begin
           memoMsg.Lines.Add('Address:' + IntToStr(j)+ ' Value:' + IntToHex(wData[i],4));
           inc( j );
        end;

end;
procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
     ShowMessage(ErrorMsg );

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
    if (Button1.Tag=0) then      // Start to Connect//
    begin

        TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
        TCPDAQ1.Open();   // Activate TCPDAQ driver //

        if TCPDAQ1.LastError<>0 then
        begin
           exit;        // Can not Connect to remote IP //
        end;
        Button1.Tag:=1;
        Button1.Caption:='Stop';
        //--- Get module name --
        mName.Text := TCPDAQ1.ModuleName;
        //--- Get module Id number --
        edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
        //--- Get AvtiveX Version --
        edtVersion.Text:=TCPDAQ1.Version;
        btnRead.Enabled:=true;

    end
    else
        begin
        Button1.Tag:=0;
        Button1.Caption:='Start';
        btnRead.Enabled:=false;
        TCPDAQ1.Close();
        end;
end;

end.
