//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;
 
type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    edtData0: TEdit;
    edtData1: TEdit;
    edtData2: TEdit;
    edtData3: TEdit;
    edtData4: TEdit;
    edtData5: TEdit;
    edtData6: TEdit;
    edtData7: TEdit;
    edtData8: TEdit;
    edtData9: TEdit;
    edtData10: TEdit;
    edtData11: TEdit;
    edtData12: TEdit;
    edtData13: TEdit;
    edtData14: TEdit;
    edtData15: TEdit;
    edtID: TEdit;
    Label36: TLabel;
    Label37: TLabel;
    btnExit: TButton;
    edtVersion: TEdit;
    btnWrite: TButton;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    mName: TEdit;
    Label38: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnWriteClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnExitClick(Sender: TObject);
begin
    //------- Disconnect to EX-9000 -------

    TCPDAQ1.Close();
    Close();
end;

procedure TForm1.btnWriteClick(Sender: TObject);
var
   i                : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   wData            : Array [0..63] of Smallint;
 
begin

       //---Set Register ---
        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        if ( (wCount<1) or (wCount>64) ) then
        begin
           ShowMessage('No. have to between 1 to 64');
           exit;
        end;

        for i := 0 to wCount - 1 do
               wData[i]:=StrToInt('$'+(FindComponent('edtData' + IntToStr(i)) As TEdit).Text);

        TCPDAQ1.ModBusWriteReg(wStartAddress, wCount, wData[0]);

end;


procedure TForm1.Button1Click(Sender: TObject);
begin
    if (Button1.Tag=0) then      // Start to Connect//
    begin

        TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
        TCPDAQ1.Open();   // Activate TCPDAQ driver //

        if TCPDAQ1.LastError<>0 then
        begin
           exit;        // Can not Connect to remote IP //
        end;
        Button1.Tag:=1;
        Button1.Caption:='Stop';
        //--- Get module name --
        mName.Text := TCPDAQ1.ModuleName;
        //--- Get module Id number --
        edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
        //--- Get AvtiveX Version --
        edtVersion.Text:=TCPDAQ1.Version;
        btnWrite.Enabled:=true;

    end
    else
        begin
        Button1.Tag:=0;
        Button1.Caption:='Start';
        btnWrite.Enabled:=false;
        TCPDAQ1.Close();
        end;
end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
         ShowMessage(ErrorMsg );
end;

end.
