//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;  // Port for Modbus/TCP


type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label5: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtIPAddress: TEdit;
    edtID: TEdit;
    edtVersion: TEdit;
    memoAIMsg: TMemo;
    btnRead: TButton;
    btnExit: TButton;
    mName: TEdit;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    mErrMsg: TEdit;
    Label4: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;
 
implementation

{$R *.DFM}

//uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

    //------- Disconnect to EX-9000 -------
     TCPDAQ1.Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i        : Integer;
  // Value    : Array [0..15] of Double;

begin

    //--- show the AI ---
    memoAIMsg.Lines.Clear();
    for i:=0 to 7 do
    begin
        TCPDAQ1.AIChannelIndex:=i;
        memoAIMsg.Lines.Add('CH:' + IntToStr(i)
                           + ' -> Value:' + Format('%6.3f',[TCPDAQ1.AINormalValue]) );
    end;
    memoAIMsg.Lines.Add('Averaging CH:' + ' ->   Value:' + Format('%6.3f', [TCPDAQ1.AIAverageValue]) );


end;


procedure TForm1.Button1Click(Sender: TObject);
var
i : integer;
begin

    TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
    TCPDAQ1.Open();

    if TCPDAQ1.LastError<>0 then
    begin
           exit;
    end;

    //--- Get module name --
    mName.Text := TCPDAQ1.ModuleName;
    //--- Get module Id number --
    edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
    btnRead.Enabled:=true;
end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
     mErrMsg.Text:= ErrorMsg;
     ShowMessage(ErrorMsg );
end;

end.
