//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    Label4: TLabel;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label5: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtIPAddress: TEdit;
    edtID: TEdit;
    edtVersion: TEdit;
    memoDIMsg: TMemo;
    memoDOMsg: TMemo;
    btnRead: TButton;
    btnExit: TButton;
    mName: TEdit;
    Button1: TButton;
    TCPDAQ1: TTCPDAQ;
    mErrMsg: TEdit;
    Label7: TLabel;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation
// uses TCPDAQ;
{$R *.DFM}


procedure TForm1.btnExitClick(Sender: TObject);
begin
     //------- Disconnect to EX-9000 -------
 //    TCP_Disconnect();
     TCPDAQ1.Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);

var
    i       : Integer;
    byDI    : Array [0..15] of Byte;
    byDO    : Array [0..15] of Byte;
begin

        for i := 0 to 15 do
        begin
            byDI[i]:=255;
            byDO[i]:=255;
        end;

        for i:=0 to 15 do
        begin

          TCPDAQ1.DIChannelIndex:=i;
          byDI[i]:=TCPDAQ1.DIStatus;
        end;

        for i:=0 to 15 do
        begin

          TCPDAQ1.DOChannelIndex:=i;
          byDO[i]:=TCPDAQ1.DOStatus;
        end;


        //--- show ---
        memoDIMsg.Lines.Clear();
        for i:=0 to 15 do
        begin
        if byDI[i]=255 then break;
           memoDIMsg.Lines.Add('DI:' + IntToStr(i)
                           + '   Value:' + IntToStr(byDI[i]) );
        end;
        //--- show the D/O ---
        memoDOMsg.Lines.Clear();
        for i:=0 to 15 do
        begin
        if byDO[i]=255 then break;
           memoDOMsg.Lines.Add('DO:' + IntToStr(i)
                           + '   Value:' + IntToStr(byDO[i]) );
        end;


end;


procedure TForm1.Button1Click(Sender: TObject);
var
i : integer;
begin

    TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
    TCPDAQ1.Open();

    if TCPDAQ1.LastError<>0 then
    begin
      exit;
    end;

    //--- Get module name --
    mName.Text := TCPDAQ1.ModuleName;
    //--- Get module Id number --
    edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
    edtVersion.text:=TCPDAQ1.Version;
    btnRead.Enabled:=true;

end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
      mErrMsg.Text:= ErrorMsg;
     ShowMessage(ErrorMsg );
end;

end.
