unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;  // Port for Modbus/TCP


type
  TForm1 = class(TForm)
    btnExit: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtCommand: TEdit;
    Label4: TLabel;
    edtVersion: TEdit;
    Bevel1: TBevel;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    edtReceive: TEdit;
    Label5: TLabel;
    edtModbusSend: TEdit;
    Label6: TLabel;
    edtModbusReceive: TEdit;
    Bevel3: TBevel;
    btnSend: TButton;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure edtCommandKeyPress(Sender: TObject; var Key: Char);
    procedure Button1Click(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.btnExitClick(Sender: TObject);
begin

    //---  disconnt connection to 9000 ---
    TCPDAQ1.Close();
    close();
end;

procedure TForm1.btnSendClick(Sender: TObject);

begin

       TCPDAQ1.ASCIICommandSend:= edtCommand.Text;
       edtReceive.Text:=TCPDAQ1.ASCIICommandReceive;

end;

procedure TForm1.edtCommandKeyPress(Sender: TObject; var Key: Char);
begin
     if Key = #13 then btnSendClick(Sender);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin

    TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
    TCPDAQ1.Open();

    if TCPDAQ1.LastError<>0 then
    begin
           exit;
    end;

     //--- Get module Version number --
    edtVersion.Text:= TCPDAQ1.Version;
    btnSend.Enabled:=true;
end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
         ShowMessage(ErrorMsg );
end;

end.

