//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls, OleCtrls, TCPDAQLib_TLB;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartDO: TEdit;
    lblMaxNo: TLabel;
    edtCount: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    RadioGroup0: TRadioGroup;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    RadioGroup5: TRadioGroup;
    RadioGroup6: TRadioGroup;
    RadioGroup7: TRadioGroup;
    RadioGroup8: TRadioGroup;
    RadioGroup9: TRadioGroup;
    RadioGroup10: TRadioGroup;
    RadioGroup11: TRadioGroup;
    RadioGroup12: TRadioGroup;
    RadioGroup13: TRadioGroup;
    RadioGroup14: TRadioGroup;
    RadioGroup15: TRadioGroup;
    Label20: TLabel;
    edtID: TEdit;
    Label22: TLabel;
    edtVersion: TEdit;
    Label21: TLabel;
    btnExit: TButton;
    btnWrite: TButton;
    mName: TEdit;
    TCPDAQ1: TTCPDAQ;
    Button1: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnWriteClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
      const ErrorMsg: WideString);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

     //------- Disconnect to EX-9000 -------
     TCPDAQ1.Close();
     Close();
end;

procedure TForm1.btnWriteClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   wModuleName      : WORD;
   wStartDO         : WORD;
   wCount           : WORD;
   byData           : Array [0..63] of Byte;
  //dName  : pChar;

  //      Mid : Byte;
begin


        //--- Digital Output for 9000 series ---
        wStartDO := StrToInt(edtStartDO.Text);
        wCount := StrToInt(edtCount.Text);
        if ( (wCount<1) or (wCount>128) ) then
        begin
           ShowMessage('No. have to between 1 to 128');
           exit;
        end;

	for i := 0 to wCount - 1 do
        begin
             if(  (FindComponent('RadioGroup' + IntToStr(wStartDO+i)) As TRadioGroup).ItemIndex=0 ) then
                 byData[i]:=0
             else
                 byData[i]:=1;
        end;

        for i:=wStartDO to   wStartDO+ wCount - 1 do
        begin
           TCPDAQ1.DOChannelIndex:=i;
           TCPDAQ1.DOStatus:= byData[i];
        end;

end;


procedure TForm1.Button1Click(Sender: TObject);
begin

    TCPDAQ1.ModuleIP:=PChar(edtIPAddress.Text);
    TCPDAQ1.Open();

    if TCPDAQ1.LastError<>0 then
    begin
           exit;
    end;

    //--- Get module name --
    mName.Text := TCPDAQ1.ModuleName;
    //--- Get module Id number --
    edtId.Text:= IntToStr( TCPDAQ1.ModuleIDNo);
    btnWrite.Enabled:=true;
    edtVersion.text:=TCPDAQ1.Version;
end;

procedure TForm1.TCPDAQ1Error(Sender: TObject; ErrorCode: Smallint;
  const ErrorMsg: WideString);
begin
           ShowMessage(ErrorMsg );
end;

end.
