//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 502  

boolean  bLoopFlag;
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

int  iReceiveCount,iThreadRun,iTotalStream=99;
char szFromIP[20];
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnExitClick(TObject *Sender)
{
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int          DLLVersion,ReturnValue;
    char         szDump[80];

    //-------- Initial DLL to working ------
    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "EX-9000MTCP demo", MB_OK+MB_ICONEXCLAMATION);
    }

}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

void __fastcall TForm1::btnStartClick(TObject *Sender)
{
   int                  iRecCount,iRecCount2;
   int                  ReturnValue;
   HANDLE               hEvent;
   AnsiString           strMsg;
   TDateTime            DateTime;
   struct _AlarmInfo   *pAlarmData,AlarmData,AlarmData2;

   btnStart->Enabled=false;
   btnStop->Enabled=true;

   //-----  create a event ---------------
   hEvent = CreateEvent(NULL,FALSE,FALSE,NULL);
   
   //--- Starting to receive the streaming data come from EX-9000MTCP --
   ReturnValue=TCP_StartEvent( edtIPAddress->Text.c_str() ,hEvent );
   if ( ReturnValue<0 )
   {
        ShowMessage("TCP_StartEvent() Failure!, Error Code:" + IntToStr(ReturnValue) );
        TCP_StopStream();
        CloseHandle(hEvent);     
        return;
   }
   
   //--- Starting to receive the streaming data come from EX-9000MTCP --
   ReturnValue=TCP_StartEvent (edtIPAddress2->Text.c_str() ,hEvent );
   if ( ReturnValue<0 )
   {
        ShowMessage("TCP_StartEvent() Failure!, Error Code:" + IntToStr(ReturnValue) );
        TCP_StopStream();
        CloseHandle(hEvent);
        return;
   }

   bLoopFlag=true;
   iRecCount=0;
   iRecCount2=0;
   memoMsg->Lines->Clear();
   

   
   while( bLoopFlag )
   {
        if ( WaitForSingleObject(hEvent, 500) == WAIT_OBJECT_0 )
        {
            if(TCP_ReadEventData(edtIPAddress->Text.c_str(),&AlarmData)==0)
            {
                if( (iRecCount % 4)==3 )
                  memoMsg->Lines->Clear();
                DateTime = Time();  // store the current date and time
                iRecCount++;
                TDateTime DateTime = Time();
                memoMsg->Lines->Add( TimeToStr(DateTime)+"  Receive Count:" + IntToStr(iRecCount));
                memoMsg->Lines->Add("Channle No: "+IntToHex(AlarmData.byChannel,3));
                memoMsg->Lines->Add("Alarm Type: "+IntToHex(AlarmData.byAlarmType,3));
                memoMsg->Lines->Add("Alarm Status: "+IntToHex(AlarmData.byAlarmStatus,3));
                memoMsg->Lines->Add("Alarm Value: "+IntToHex(AlarmData. wValue,4));
                memoMsg->Lines->Add("IP :"+IntToStr(AlarmData.szIP[0])+"."+IntToStr(AlarmData.szIP[1])+"."+IntToStr(AlarmData.szIP[2])+"."+IntToStr(AlarmData.szIP[3]));
                memoMsg->Lines->Add("   ");
            }
            if(TCP_ReadEventData(edtIPAddress2->Text.c_str(),&AlarmData2)==0)
            {
                if( (iRecCount2 % 4)==3 )
                   memoMsg2->Lines->Clear();
                iRecCount2++;
                DateTime = Time();  // store the current date and time
                memoMsg2->Lines->Add( TimeToStr(DateTime)+"  Receive Count:" + IntToStr(iRecCount2));
                memoMsg->Lines->Add( TimeToStr(DateTime)+"  Receive Count:" + IntToStr(iRecCount));
                memoMsg->Lines->Add("Channle No: "+IntToHex(AlarmData.byChannel,3));
                memoMsg->Lines->Add("Alarm Type: "+IntToHex(AlarmData.byAlarmType,3));
                memoMsg->Lines->Add("Alarm Status: "+IntToHex(AlarmData.byAlarmStatus,3));
                memoMsg->Lines->Add("Alarm Value: "+IntToHex(AlarmData. wValue,4));
                memoMsg->Lines->Add("IP :"+IntToStr(AlarmData.szIP[0])+"."+IntToStr(AlarmData.szIP[1])+"."+IntToStr(AlarmData.szIP[2])+"."+IntToStr(AlarmData.szIP[3]));
                memoMsg->Lines->Add("   ");
            }
      }
      Application->ProcessMessages();
   }

   TCP_StopStream();
   CloseHandle(hEvent);


}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnStopClick(TObject *Sender)
{
   bLoopFlag=FALSE;
   btnStart->Enabled =true;
   btnStop->Enabled=false;
}
//---------------------------------------------------------------------------

