//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 502
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnReadClick(TObject *Sender)
{
        int          i,j, iChannel;
        double       fValue[16];
        char         ch[80];
        AnsiString   s1;
        int          tcp_err;
        tcp_err=TCP_Connect(edtIPAddress->Text.c_str(),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if( tcp_err<0 )
        {
           sprintf(ch,"TCP_Connect() Failure!, Error Code:%d",tcp_err);
           MessageBox(NULL, ch, "EX-9000MTCP demo", MB_OK+MB_ICONEXCLAMATION);
           return ;
        }

        char mID;
 
        //Get Module ID //
        TCP_GetModuleID( edtIPAddress->Text.c_str(),&mID);
        edtDeviceID->Text=(int) mID;
        
        iChannel = 7;
        TCP_ReadAIValue(edtIPAddress->Text.c_str(), fValue);
        memoAIMsg->Lines->Clear();
        for(i=0; i<iChannel; i++)
        {
           memoAIMsg->Lines->Add(s1.sprintf("AI:%d Value=%5.3f",i,fValue[i]));
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
    TCP_Disconnect();
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int          DLLVersion,ReturnValue;
    char         szDump[80];

    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();


}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
        TCP_Disconnect();
        TCP_Close();
}
//---------------------------------------------------------------------------

