//-------------------- demo ------------------------------------//

#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 502
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}


void __fastcall TForm1::btnReadClick(TObject *Sender)
{
        int          i,j;
        int          ReturnValue,DLLVersion;
        BYTE         byDI[16];
        BYTE         byDO[16];
        char         ch[80];
        AnsiString   s1;
        SOCKET sock;

        //------- Connect to EX-9000MTCP -------
        ReturnValue=TCP_Connect(edtIPAddress->Text.c_str(),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if( ReturnValue<0 )
        {
           sprintf(ch,"TCP_Connect() Failure!, Error Code:%d",ReturnValue);
           MessageBox(NULL, ch, "9000MTCP Series demo", MB_OK+MB_ICONEXCLAMATION);
           return;
        }
        
        char mID;
   
        //Get Module ID //
        TCP_GetModuleID( edtIPAddress->Text.c_str(),&mID);
        edtDeviceID->Text=(int) mID;


      	for(i=0; i<16; i++)
        {
	           byDI[i]=byDO[i]=0xff;
        }
        //------------------- reading -----------
        ReturnValue=TCP_ReadDIO( edtIPAddress->Text.c_str() ,byDI, byDO);
        if( ReturnValue )
        {
           sprintf(ch,"TCP_ReadDIO() Failure!, Error Code:%d",ReturnValue);
           MessageBox(NULL, ch, "9000MTCP Series demo", MB_OK+MB_ICONEXCLAMATION);
           return;

        }

        //----------------show--------------
        memoDIMsg->Lines->Clear();
       	for(i=0; i<16; i++)
        {
           if( byDI[i]==0xff )
              break;
           memoDIMsg->Lines->Add(s1.sprintf("DI:%d   Value:%d",i,byDI[i]));
        }
        memoDOMsg->Lines->Clear();
       	for(i=0; i<16; i++)
        {
           if( byDO[i]==0xff )
              break;
           memoDOMsg->Lines->Add(s1.sprintf("DO:%d   Value:%d",i,byDO[i]));
        }

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
        //------- Disconnect to EX-9000MTCP -------
    TCP_Disconnect();
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int          DLLVersion,ReturnValue;
    char         szDump[80];
    //-------- Initial DLL to working ------
    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "9000MTCP Series demo", MB_OK+MB_ICONEXCLAMATION);
       return;
    }

}


