//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 1025
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnSendClick(TObject *Sender)
{
    int         ReturnValue,DLLVersion;
    char        ch[80];
    char        szSend[512];            
    char        szReceive[512];
    AnsiString  s1;

    ReturnValue=UDP_Connect(edtIPAddress->Text.c_str(),0,DEFAULT_PORT,iConnectionTimeout,iSendTimeout,iReceiveTimeout);
    if( ReturnValue<0 )
    {
        sprintf(ch,"UDP_Connect() Failure!, Error Code:%d",ReturnValue);
        MessageBox(NULL, ch, " demo", MB_OK+MB_ICONEXCLAMATION);
        return;
    }

    //---------- send a command ---------
    strcpy(szSend,edtCommand->Text.c_str());
    ReturnValue=UDP_SendReceiveASCcmd(edtIPAddress->Text.c_str(),szSend,szReceive)  ;
    if( ReturnValue )
    {
        sprintf(ch,"UDP_SendReceiveASCcmd() Failure!, Error Code:%d",ReturnValue);
        MessageBox(NULL, ch, "UDP demo", MB_OK+MB_ICONEXCLAMATION);
        return;
    }

    edtReceive->Text=AnsiString(szReceive);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
    //------- Disconnect--------------
    UDP_Disconnect();
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int   DLLVersion,ReturnValue;
    char  szDump[80];
    //-------- Initial DLL to working ------
    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "9000/TCP demo", MB_OK+MB_ICONEXCLAMATION);
       Close();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
    btnSend->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    //------- Disconnect--------------
    UDP_Disconnect();
    TCP_Close();
}
//---------------------------------------------------------------------------


