//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop
#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 502

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnSendClick(TObject *Sender)
{
    int         ReturnValue,DLLVersion;
    char        ch[80];
    char        szSend[512];
    char        szReceive[512];
    SOCKET      sock;
    //--- Connect to EX-9000MTCP ---
    ReturnValue=TCP_Connect(edtIPAddress->Text.c_str(),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
    if( ReturnValue<0 )
    {
        sprintf(ch,"UDP_Connect() Failure!, Error Code:%d",ReturnValue);
        MessageBox(NULL, ch, " demo", MB_OK+MB_ICONEXCLAMATION);
        return;
    }

    strcpy(szSend,edtCommand->Text.c_str());
    ReturnValue=TCP_SendReceiveASCcmd(edtIPAddress->Text.c_str(), szSend, szReceive);
    if( ReturnValue )
    {
        sprintf(ch,"TCP_SendReceiveASCcmd() Failure!, Error Code:%d",ReturnValue);
        MessageBox(NULL, ch, "EX-9000MTCP Series Demo", MB_OK+MB_ICONEXCLAMATION);
        return;
    }
    edtReceive->Text=AnsiString(szReceive);

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
    //------- Disconnect to EX-9000MTCP -------
    TCP_Disconnect();
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int   DLLVersion,ReturnValue;
    char  szDump[80];

    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);

    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "9000MTCP Series demo", MB_OK+MB_ICONEXCLAMATION);
       return;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormActivate(TObject *Sender)
{
    btnSend->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    //------- Disconnect to EX-9000MTCP -------
    TCP_Disconnect();
    TCP_Close();
}
//---------------------------------------------------------------------------

