//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\include\TCPDAQ.H"


#define DEFAULT_PORT 502
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnExitClick(TObject *Sender)
{
        TCP_Disconnect();
        Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnWriteClick(TObject *Sender)
{
        int          i,j;
        int          ReturnValue,DLLVersion;
        WORD         wStartDO;
        WORD         wCount;
        BYTE         byData[128];
        char         ch[80];
        AnsiString   s1;
        TRadioGroup* pRadioGrp;
        SOCKET       sock ;

  //      DLLVersion=TCP_GetDLLVersion();
        //--- Connect to EX-9000MTCP ---
        ReturnValue=TCP_Connect(edtIPAddress->Text.c_str(),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);

        if( ReturnValue<0 )
        {
           sprintf(ch,"Connect Failure!, Error Code:%d",ReturnValue);
           MessageBox(NULL, ch, "9000MTCP Digital Output demo", MB_OK+MB_ICONEXCLAMATION);
           TCP_Close();
           Close();
        }

        char Name[20], mID;
        // Get Module name//
        TCP_GetModuleNo( edtIPAddress->Text.c_str(),Name);
        eName->Text=Name ;

        //Get Module ID //
        TCP_GetModuleID( edtIPAddress->Text.c_str(),&mID);
        edtDeviceID->Text=(int) mID;


        wStartDO=StrToInt(edtStartDO->Text);
        wCount=StrToInt(edtCount->Text);
        if( wCount<1 || wCount>16 )
        {
           sprintf(ch,"No. have to between 1 to 16");
           MessageBox(NULL, ch, "EX-9000MTCP demo", MB_OK+MB_ICONEXCLAMATION);
           return;
        }
        for(i=0; i<wCount; i++)
        {
           pRadioGrp=(TRadioGroup *)(FindComponent("RadioGroup"+IntToStr(wStartDO+i)));
  	   byData[i]=pRadioGrp->ItemIndex;
        }
        //--- Sst coils ---
        ReturnValue=TCP_WriteDO(edtIPAddress->Text.c_str(), wStartDO, wCount,byData);
        if( ReturnValue )
        {
           sprintf(ch,"TCP_WriteDO() Failure!, Error Code:%d",ReturnValue);
           MessageBox(NULL, ch, "EX-9000MTCP Digital Output demo", MB_OK+MB_ICONEXCLAMATION);
           return;
         }

        //------- Disconnect to EX-9000MTCP -------

}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int          DLLVersion,ReturnValue;
    char         szDump[80];
    //-------- Initial DLL to working ------
    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "EX-9000MTCP Digital Output demo", MB_OK+MB_ICONEXCLAMATION);
       Close();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
        TCP_Disconnect();
        TCP_Close();
}
//---------------------------------------------------------------------------



