//-------------------- demo ------------------------------------//
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include "Unit1.h"
#include <winsock2.h>
#include "..\..\Include\TCPDAQ.H"

#define DEFAULT_PORT 502  

int     iRecCount=0,iRecCount2=0;
struct _StreamData   *pStreamData,StreamData,StreamData2;

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnExitClick(TObject *Sender)
{
     Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
    int          DLLVersion,ReturnValue;
    char         szDump[80];
    //-------- Initial DLL to working ------
    DLLVersion=TCP_GetDLLVersion();
    edtVersion->Text=IntToHex(DLLVersion,4);
    ReturnValue=TCP_Open();
    if( ReturnValue<0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",ReturnValue);
       MessageBox(NULL, szDump, "EX-9000MTCP demo", MB_OK+MB_ICONEXCLAMATION);
       return;
    }

}
//---------------------------------------------------------------------------


void __fastcall TForm1::btnStartClick(TObject *Sender)
{
  int           iReceiveCount;
  int           ReturnValue;
  HANDLE        hEvent;
  AnsiString    strMsg;
   HANDLE       *null;
   btnStart->Enabled=false;
   btnStop->Enabled=true;
   btnExit->Enabled=false;

   //--- Start  for streaming ----
   ReturnValue=TCP_StartStream( edtIPAddress->Text.c_str(),0 );
   ReturnValue=TCP_StartStream( edtIPAddress2->Text.c_str(),0 );

   iReceiveCount=0;
   memoMsg->Lines->Clear();
   //--- Starting from EX-9000MTCP ---
   Timer1->Interval=StrToInt( edtTime->Text );
   Timer1->Enabled=true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnStopClick(TObject *Sender)
{
   Timer1->Enabled=false;
   btnStart->Enabled =true;
   btnStop->Enabled=false;
   btnExit->Enabled=true;
   TCP_StopStream();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
         int         ReturnValue;
         //--- reading stream data  first EX-9000MTCP ---
         if(TCP_ReadStreamData(edtIPAddress->Text.c_str(),&StreamData)==0)
         {
            if( (iRecCount % 4)==3 )
                memoMsg->Lines->Clear();
            iRecCount++;
            TDateTime DateTime = Time();
            memoMsg->Lines->Add( TimeToStr(DateTime)+"  Receive Count:" + IntToStr(iRecCount));
            memoMsg->Lines->Add("DIN: "+IntToHex(StreamData.DIN,3));
            memoMsg->Lines->Add("DOUT: "+IntToHex(StreamData.DOUT,3));
            memoMsg->Lines->Add("   ");
         }
         
         //--- reading stream data from second EX-9000MTCP ---
         if(TCP_ReadStreamData(edtIPAddress2->Text.c_str(),&StreamData2)==0)
         {
            if( (iRecCount2 % 4)==3 )
              memoMsg2->Lines->Clear();
            
            iRecCount2++;
            TDateTime DateTime1 = Time();
            memoMsg2->Lines->Add( TimeToStr(DateTime1)+"  Receive Count:" + IntToStr(iRecCount2));
            memoMsg2->Lines->Add("DIN: "+IntToHex(StreamData2.DIN,3));
            memoMsg2->Lines->Add("DOUT: "+IntToHex(StreamData2.DOUT,3));
            memoMsg2->Lines->Add("   ");
        }
        
}
//---------------------------------------------------------------------------

