
//*******************************************************//
// TCPDAQ.DLL Ver 1.1  Issued Date:03/28/2008            //
// TOPSCCC All Right reserved 2008,2009,2010             //
//*******************************************************//

typedef  unsigned short  u_short;
typedef  unsigned long   u_long;
typedef  unsigned char   u_char;

#ifndef __TCPDAQ_h__
#define __TCPDAQ_h__

#define  TCP_MODBUS_PORT      502
#define  UDP_ASC_PORT         1025
#define  UDP_BROADCAST_PORT   5048
#define  BROADCAST_IP         "255.255.255.255"
#define  TCP_STREAM_PORT      5168

#define  TCP_DLLVERSION        0x0330
#define  TCP_MAXSOCKETS        100
#define  UDP_MAXSOCKETS        100
#define  TCP_DATABUFFLEN       2000

#define  TCP_TYPE              SOCK_STREAM
#define  UDP_TYPE              SOCK_DGRAM
#define  MAXMODULES            64

#define  SORT_MODULE_IP        10
#define  SORT_MODULE_ID        11
#define  SORT_MODULE_NO        12

#define  LOW_ALARM             0
#define  HIGH_ALARM            1

#define  MOMEMTARY_ALARM       0
#define  LATCH_ALARM           1
#define  DISABLE_ALARM         2

#define  STREAM_PATTERN_ID     0xa002
#define  EVENT_PATTERN_ID      0xa001

//Using these function libraries,you can read the error message from the return codes//
#define  TCP_NOERROR                0    //No_error
#define  TCP_STARTUPFAILURE         -1   //Windows winsock2 start up error
#define  TCP_SOCKETFAILURE          -2   //Can not create TCP socket
#define  TCP_UDPSOCKETFAILURE       -3   //Can not create UDP socket
#define  TCP_SETTIMEOUTFAILURE      -4   //Can not set TCP/IP timeout
#define  TCP_SENDFAILURE            -5   //Can not send package to destination
#define  TCP_RECEIVEFAILURE         -6   //No package received until timeout 
#define  TCP_INVALIDRANGEFAILURE    -7   //Invalid range
#define  TCP_CREATEWSAEVENTFAILURE  -8
#define  TCP_READSTREAMDATAFAILURE  -9   //Unable to read stream data
#define  TCP_INVALIDIP              -10  //Invalid IP address
#define  TCP_THISIPNOTCONNECTED     -11  //No Connection to remote IP address
#define  TCP_ALARMINFOEMPTY         -12  //Alarm event buffer empty
#define  TCP_STREAMINFOEMPTY        -13  //Stream event buffer empty
#define  TCP_NOTSUPPORTMODULE       -14  //Not supported module
#define  TCP_NOTOPEN                -15  //TCPDAQ.DLL is not opened
#define  TCP_MEMALLOCERROR          -16  //Unable to allocate memory
#define  TCP_INVALIDID              -17  //illegal ID number
#define  TCP_PINGTIMEOUT            -18  //Can not ping remote IP address
#define  TCP_NOT_INSUBNET           -19  //IP not in subnet

// Types of EX9017 module //
#define  TCP_BI_10V                 0    // -10V~10V
#define  TCP_BI_5V                  1    // -5V~5V
#define  TCP_BI_2Point5V            2    // -2.5V~2.5V
#define  TCP_BI_1V                  3    // -1V~1V
#define  TCP_BI_500mV               4    // -500mV~500mV
#define  TCP_BI_150mV               5    // -150mV~150mV
#define  TCP_BI_100mV               6    // -100mV~100mV
#define  TCP_BI_50mV                7    // -50mV~50mV
#define  TCP_BI_15mV                8    // -15mV~ 15mV
#define  TCP_UNI_4TO20mA            9    // 4~20mA
#define  TCP_UNI_0TO20mA            10   // 0~20mA
#define  TCP_BI_20mA                11   // -20~20mA

// Types of EX9019 module //
#define  TCP_TypeJ                  14   // TypeJ 0~760'C
#define  TCP_TypeK                  15   // TypeK 0~1370'C
#define  TCP_TypeT                  16   // TypeT -100~400'C
#define  TCP_TypeE                  17   // TypeE 0~1000'C
#define  TCP_TypeR                  18   // TypeR 500~1750'C
#define  TCP_TypeS                  19   // TypeS 500-1750'C
#define  TCP_TypeB                  20   // TypeB 500~1800'C

//-- Types of EX-9015  module ---
#define  TCP_PT100_50TO150A         32   // PT100(a=385) 50~15'C
#define  TCP_PT100_0TO100A          33   // PT100(a=385) 0~100'C
#define  TCP_PT100_0TO200A          34   // PT100(a=385) 0~200'C
#define  TCP_PT100_0TO400A          35   // PT100(a=385) 0~400'C
#define  TCP_PT100_200TO200A        36   // PT100(a=385) -200~200'C
#define  TCP_PT100_50TO150B         37   // PT100(a=392) -50~150'C
#define  TCP_PT100_0TO100B          38   // PT100(a=392) 0~100'C
#define  TCP_PT100_0TO200B          39   // PT100(a=392) 0~200'C
#define  TCP_PT100_0TO400B          40   // PT100(a=392) 0~400'C
#define  TCP_PT100_200TO200B        41   // PT100(a=392) -200~200'C
#define  TCP_PT1000_40TO160         42   // PT1000 -40~160'C
#define  TCP_BALCO_30TO120          43   // Baclo(500) -30~100'C
#define  TCP_NI604_80TO100          44   // Ni(604 a=518) -80~100'C
#define  TCP_NI604_0TO100           45   // Ni(604 a=518) 0~100'C

/*============================================================================*/
/* data structure                                                             */
/*============================================================================*/

struct _AlarmInfo
{
   u_char   szIP[4];       //The IP address which cause the alarm change
   u_short  szDateTime[6]; //E.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   u_short  byChannel;     //The Channel of which cause the alarm change
   u_short  byAlarmType;   //0x00:AIO Low Alarm
                           //0x01:AIO High Alarm
                           //0x20:DIO Alarm
                           //0xF0:Connection Alarm
   u_short  byAlarmStatus; //0:Alarm ON to OFF, 1:Alarm OFF to ON
   u_short  wValue;        //Alarm value.For DIO, this value could be "0" or "1" means that "ON" or "OFF"
                           //            For high or low alarm, this is the AIO value.
                           //            For connection lost, this value is 0.
};

typedef struct _StreamData
{
   u_char  szIP[4];        //The IP address which send the stream datae
   u_short  szDateTime[6]; //E.x [2001]/[09]/[23] [10]:[12]:[34] (Year/Month/Day Hour:Minute:Second)
   u_short  DIN;           //Digital input data (DI#0~DI#15)
   u_short  DOUT;          //Digital output data (DO#0~DO#15)
   u_short  wData[32];     //Digital input Counter (Each channel occupies 4 Byte)
} _StreamData;

typedef struct ModuleInfo
{
   u_char  szIP[4];        //0,1,2,3            IP address
   u_char  szGate[4];      //4,5,6,7            Gateway
   u_char  szMask[4];      //8,9,10,11          Submask
   u_char  szDHCP;         //12                 DHCP status 01=enable, 00=disable
   u_char  szID;           //13                 Module ID number
   u_char  szWeb;          //33                 web server status 0=disabled,1=enabled
   u_char  szVersionH;     //34 
   u_char  szVersionL;     //35
   u_char  szMacAddr[6];   //14,15,16,1,18,19   MAC address of module
   u_short szModuleNo;     //20                 Module name
   u_char  szBuffer[12];   //21,22,23,24,25,26,27,28,29,30,31,32 Buffer reserved for TCPDAQ.DLL
   

} ModuleInfo;

typedef struct ModuleData     //All data for module used for function TCP_ReadAllDataFromModule (..)
{
   u_char   Din[16];          //Digital input data (DI#0~DI#15),avaliable for EX9050,9051,9055
   u_char   Dout[16];         //Digital output data (DO#0~DO#15),avaliable for EX9050,9051,9055,9017,9019
   u_char   DiLatch[16];      //Digital input latch status (DI#0~DI#15),avaliable for EX9050,9051,9055
   long     DiCounter[16];    //Digital input counter value (DI#0~DI#15),avaliable for EX9050,9051,9055
   double   AiNormalValue[16];//Analog Input value(AI#0~AI#15),avaliable for EX9015,9017,9019
   double   AiMaxValue[16];   //Analog maximum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   double   AiMinValue[16];   //Analog minimum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   u_char   AiHighAlarm[16];  //Analog high alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   u_char   AiLowAlarm[16];   //Analog low alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   u_char   AiChannelType[16];//Analog channel Type, avaliable for EX9015,9017,9019
   u_char   AiBurnOut[16] ;   //Analog channel burn out status,avaliable for EX9019,9015 only
   double   CJCTemperature  ; //Cold junction temperature,avaliable for EX9019 only
}ModuleData;

#ifdef __cplusplus
     #define EXPORTS extern "C" __declspec (dllexport)
#else
     #define EXPORTS
#endif

//---- TCP/IP declarations -----------------------------------------------------------------------//
EXPORTS int    CALLBACK TCP_GetDLLVersion(void);
EXPORTS int    CALLBACK TCP_Open(void);
EXPORTS void   CALLBACK TCP_Close(void);

EXPORTS int    CALLBACK TCP_ScanOnLineModules( struct ModuleInfo *ModuleIP, u_char SortKey);
EXPORTS int    CALLBACK TCP_Connect(char szIP[],u_short port,int iConnectionTimeout,int iSendTimeout,int iReceiveTimeout);
EXPORTS void   CALLBACK TCP_Disconnect(void);
EXPORTS int    CALLBACK TCP_ModuleDisconnect(char szIP[]);
EXPORTS int    CALLBACK TCP_SendData(char szIP[],char *pData,u_short wDataLen);
EXPORTS int    CALLBACK TCP_RecvData(char szIP[],char *pData,u_short wBufferLen);
EXPORTS int    CALLBACK TCP_SendReceiveASCcmd(char szIP[], char tcpsend[], char tcpRecv[]);

EXPORTS int    CALLBACK TCP_GetLastError(void);
EXPORTS int    CALLBACK TCP_PingIP(char *IP,int timeout);

EXPORTS int    CALLBACK TCP_GetModuleNo(char szIP[],char *Name);
EXPORTS int    CALLBACK TCP_GetModuleIPinfo( char szIP[],struct ModuleInfo *ModuleIP);
EXPORTS int    CALLBACK TCP_GetModuleID(char szIP[],char *Name);
EXPORTS int    CALLBACK TCP_GetIPFromID(char szID ,char szIP[]);

EXPORTS int    CALLBACK TCP_IsIPInLocalSubnet (char *bLocalIP,char  *bRemoteIP);

//---- Module stream event-----------------------------------------------------------//
EXPORTS int    CALLBACK TCP_StartStream(char szIP[],HANDLE EventFromApp);
EXPORTS int    CALLBACK TCP_StopStream(void);
EXPORTS int    CALLBACK TCP_ReadStreamData (char szIP[], struct _StreamData *lpData);

//---- Module Alarm event -----------------------------------------------------------//
EXPORTS int    CALLBACK TCP_StartEvent(char szIP[],HANDLE EventFromApp);
EXPORTS int    CALLBACK TCP_StopEvent(void);
EXPORTS int    CALLBACK TCP_ReadEventData (char szIP[], struct _AlarmInfo *lpData);
EXPORTS int    CALLBACK TCP_ReadAllDataFromModule(char szIP[],struct ModuleData *ModuleData);

//---- Digital I/O declarations ------------------------------------------------------------------//

EXPORTS int    CALLBACK TCP_ReadDIOMode(char szIP[],u_char byDImode[],u_char byDOmode[]);
EXPORTS int    CALLBACK TCP_ReadDIO(char szIP[],u_char u_byDI[],u_char byDO[] );
EXPORTS int    CALLBACK TCP_ReadDISignalWidth(char szIP[],u_long ulLoWidth[],u_long ulHiWidth[]);
EXPORTS int    CALLBACK TCP_WriteDISignalWidth(char szIP[],u_long ulLoWidth[],u_long ulHiWidth[]);
EXPORTS int    CALLBACK TCP_ReadDICounter(char szIP[],u_long ulCounterValue[]);
EXPORTS int    CALLBACK TCP_ClearDICounter(char szIP[],u_short wChNo);
EXPORTS int    CALLBACK TCP_StartDICounter(char szIP[],u_short  wChNo);
EXPORTS int    CALLBACK TCP_StopDICounter(char szIP[],u_short  wChNo);
EXPORTS int    CALLBACK TCP_ClearDILatch(char szIP[],u_short  wChNo);
EXPORTS int    CALLBACK TCP_ReadDILatch(char szIP[],u_char wLatch[]);
EXPORTS int    CALLBACK TCP_WriteDO(char szIP[], u_short wStartDO, u_short wCount, u_char byDO[]);
EXPORTS int    CALLBACK TCP_WriteDOPulseCount(char szIP[],u_short wDoChannel,u_long ulPulseCount);
EXPORTS int    CALLBACK TCP_WriteDODelayWidth(char szIP[],
                                               u_short wChno,
                                               u_long ulLoPulseWidth,  // Pulse Min output signal width at low level
                                               u_long ulHiPulseWidth,  // Pulse Min output signal width at high level
                                               u_long ulLoDelayWidth,  // Delay Min output signal width at low level
                                               u_long ulHiDelayWidth); // Delay Min output signal width at high level
EXPORTS int    CALLBACK TCP_ReadDODelayWidth(char szIP[],u_short wChno,
                                              u_long *ulLoPulseWidth,  // Pulse Min output signal width at low level
                                              u_long *ulHiPulseWidth,  // Pulse Min output signal width at high level
                                              u_long *ulLoDelayWidth,  // Delay Min output signal width at low level
                                              u_long *ulHiDelayWidth); // Delay Min output signal width at high level

//---- Analog input declarations -----------------------------------------------------------------//

EXPORTS int    CALLBACK TCP_ReadAIValue(char szIP[],double dlValue[]);
EXPORTS int    CALLBACK TCP_ReadAITypes(char szIP[],u_char szTypes[]);
EXPORTS int    CALLBACK TCP_ReadAIMaxVal(char szIP[],double dMaxValue[]);
EXPORTS int    CALLBACK TCP_ReadAIMinVal(char szIP[],double dMinValue[]);
EXPORTS int    CALLBACK TCP_WriteAIMultiplexChannel(char szIP[],u_char szChno[]);
EXPORTS int    CALLBACK TCP_ReadAIMultiplexChannel(char szIP[],u_char szChno[]);
EXPORTS int    CALLBACK TCP_ReadAIAverageChannel(char szIP[],u_char avgch[]);
EXPORTS int    CALLBACK TCP_WriteAIAverageChannel(char szIP[],u_char avgch[]);

EXPORTS int    CALLBACK TCP_ReadAIAlarmTypes(char szIP[],u_short AIchno, u_char *AIHialarmtype,u_char *AILoalarmtype);
EXPORTS int    CALLBACK TCP_WriteAIAlarmType(char szIP[],u_short AIchno, u_char HilowAlarm,u_char AIHialarmtype);

EXPORTS int    CALLBACK TCP_ReadAIAlarmDOConnection(char szIP[],u_short AIchno, u_short *AIHiAlarmDOchn,u_short *AILoAlarmDOchn);
EXPORTS int    CALLBACK TCP_WriteAIAlarmDOConnection(char szIP[],u_short AIchno, u_short HiAlarmDOchn,u_short LoAlarmDOchn);
EXPORTS int    CALLBACK TCP_ReadAIBurnOutStatus(char szIP[],u_char dlBurnout[]);

EXPORTS int    CALLBACK TCP_ReadAIAlarmStatus(char szIP[],u_short Chno,u_char *szHighAlarm,u_char *szLowAlarm);
EXPORTS int    CALLBACK TCP_ClearAILatchAlarm(char szIP[],u_short Chno,u_char Alarmlevel);
EXPORTS int    CALLBACK TCP_ClearAIMaxVal(char szIP[],u_short Chno);
EXPORTS int    CALLBACK TCP_ClearAIMinVal(char szIP[],u_short Chno);

EXPORTS int    CALLBACK TCP_WriteAIAlarmLimit(char szIP[],u_short Chno, double dHighLimit, double dLowLimit);
EXPORTS int    CALLBACK TCP_ReadAIAlarmLimit(char szIP[],u_short Chno, double dHighLimit[], double dLowLimit[]);
EXPORTS int    CALLBACK TCP_StartAIAlarm(char szIP[],u_short Chno,u_char alarmlevel);
EXPORTS int    CALLBACK TCP_StopAIAlarm(char szIP[],u_short Chno,u_char alarmlevel);

EXPORTS int    CALLBACK TCP_WriteCJCOffset(char szIP[],double CJoffset);
EXPORTS int    CALLBACK TCP_ReadCJCOffset(char szIP[],double *CJoffset);
EXPORTS int    CALLBACK TCP_ReadCJCTemperature(char szIP[],double *CJTemp);

//---- TCP/IP MODBUS declarations ----------------------------------------------------------------//

EXPORTS int    CALLBACK TCP_MODBUS_ReadCoil(char szIP[],u_short wStartAddress,u_short wCount,u_char byData[]);
EXPORTS int    CALLBACK TCP_MODBUS_WriteCoil(char szIP[],u_short wStartAddress,u_short wCount,u_char byData[]);
EXPORTS int    CALLBACK TCP_MODBUS_ReadReg(char szIP[],u_short wStartAddress,u_short wCount,u_short wData[]);
EXPORTS int    CALLBACK TCP_MODBUS_WriteReg(char szIP[],u_short wStartAddress,u_short wCount,u_short wData[]);

//---- UDP/IP declarations -----------------------------------------------------------------------//

EXPORTS int CALLBACK UDP_Connect(char szIP[],u_short s_port,u_short d_port,int iConnectionTimeout,int iSendTimeout,
                                    int iReceiveTimeout);
EXPORTS void   CALLBACK UDP_Disconnect(void);
EXPORTS int    CALLBACK UDP_ModuleDisconnect(char szIP[]);
EXPORTS int    CALLBACK UDP_SendData(char szIP[],char *pData,u_short wDataLen);
EXPORTS int    CALLBACK UDP_RecvData(char szIP[],char *pData,u_short wBufferLen);
EXPORTS int    CALLBACK UDP_SendReceiveASCcmd(char szIP[],char udpsend[],char udprecv[]);

//--------------------------------------------------------------------------------------------//

#endif


