unit TCPDAQ;          { TCPDAQ.dll interface unit }

interface

uses Winsock;

Type
   PDouble = ^Double;
   PWord = ^WORD;
   PByte = ^BYTE;

TModuleInfo  = Record

   szIP        : array[0..3] of Byte ;       //IP address of on line modules
   szGate      : array[0..3] of Byte ;       //Gateway on line modules
   szMask      : array[0..3] of Byte ;       //Mask of on line modules
   szDHCP      : Byte;                       //DHCP status
   szID        : Byte;                       //Module ID
   szMacAddr   : array[0..5] of Byte ;       //MAC address
   szModuleNo  : Integer   ;                 //Module number of on line modules

End;


TEventInfo = Record

   szIP        : array[0..3] of Byte ;       //The IP address which cause the alarm change
   szDateTime  : array[0..5] of Integer;     //E.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   byChannel   : Integer;                    //The Channel of which cause the alarm change
   byAlarmType : Integer;                    //0x00:AIO Low Alarm
                                             //0x01:AIO High Alarm
                                             //0x20:DIO Alarm
                                             //0xF0:Connection Alarm
   byAlarmStatus : Integer;                  //0:Alarm ON to OFF, 1:Alarm OFF to ON
   wValue : Integer  ;                       //Alarm value.For DIO, this value could be "0" or "1" means that "ON" or "OFF"
                                             //            For high or low alarm, this is the AIO value.
                                             //            For connection lost, this value is 0.
End;


TModuleData = Record                         //All data for module used for function TCP_ReadAllDataFromModule (..)

   Din            : array[0..15] of Byte;    //Digital input data (DI#0~DI#15),avaliable for EX9050,9051,9055
   Dout           : array[0..15] of Byte;    //Digital output data (DO#0~DO#15),avaliable for EX9050,9051,9055,9017,9019
   DiLatch        : array[0..15] of Byte;    //Digital input latch status (DI#0~DI#15),avaliable for EX9050,9051,9055
   DiCounter      : array[0..15] of  Longint;//Digital input counter value (DI#0~DI#15),avaliable for EX9050,9051,9055
   AiNormalValue  : array[0..15] of double;  //Analog Input value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiMaxValue     : array[0..15] of double;  //Analog maximum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiMinValue     : array[0..15] of double;  //Analog minimum value(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiHighAlarm    : array[0..15] of Byte;    //Analog high alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiLowAlarm     : array[0..15] of Byte;    //Analog low alarm status(AI#0~AI#15),avaliable for EX9015,9017,9019
   AiChannelType  : array[0..15] of Byte;    //Analog channel Type, avaliable for EX9015,9017,9019
   AiBurnOut      : array[0..15] of Byte ;   //Analog channel burn out status,avaliable for EX9019,9015 only
   CJCTemperature : double  ;                 //Cold junction temperature,avaliable for EX9019 only


End;

TStreamData = Record
    szIP        : array[0..3] of Byte ;    // the IP address which cause the alarm change
    szDateTime  : array[0..5] of word ;    // e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
    DIN         : word  ;                  // DI/DO data for Slot0; Slot1;....; Slot7
    Dout        : word  ;                  // AI/AO data for slot0
    wData       : array[0..31] of word     // AI/AO data for slot1
End;

TAIOStreamData= Record
    szIP        : array[0..3] of Byte ;    // the IP address which cause the alarm change
    szDateTime  : array[0..5] of word ;    // e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
    DIN         : word  ;                  // DI/DO data for Slot0; Slot1;....; Slot7
    Dout        : word  ;                  // AI/AO data for slot0
    wData       : array[0..31] of word     // AI/AO data for slot1
End;

TDIOStreamData= Record
    szIP        : array[0..3] of Byte ;    // the IP address which cause the alarm change
    szDateTime  : array[0..5] of word ;    // e.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
    DIN         : word   ;                 // DI/DO data for Slot0; Slot1;....; Slot7
    Dout        : word   ;                 // AI/AO data for slot0
    wData       : array[0..31] of word     // AI/AO data for slot1
End;


//------------------ define error code -----------------------
const

MAXMODULES = 64;
SORT_MODULE_IP = 10;
SORT_MODULE_ID = 11;
SORT_MODULE_NO = 12;

//Using these function libraries,you can read the error message from the returning codes//
TCP_NOERROR                =0    ;//No_error
TCP_STARTUPFAILURE         =-1   ;//Windows winsock2 start up error
TCP_SOCKETFAILURE          =-2   ;//Can not create TCP socket
TCP_UDPSOCKETFAILURE       =-3   ;//Can not create UDP socket
TCP_SETTIMEOUTFAILURE      =-4   ;//Can not set TCP/IP timeout
TCP_SENDFAILURE            =-5   ;//Can not send package to destination
TCP_RECEIVEFAILURE         =-6   ;//No package received until timeout
TCP_INVALIDRANGEFAILURE    =-7   ;//Invalid range
TCP_CREATEWSAEVENTFAILURE  =-8   ;
TCP_READSTREAMDATAFAILURE  =-9   ;//Unable to read stream data
TCP_INVALIDIP              =-10  ;//Invalid IP address
TCP_THISIPNOTCONNECTED     =-11  ;//No Connection to remote IP address
TCP_ALARMINFOEMPTY         =-12  ;//Alarm event buffer empty
TCP_STREAMINFOEMPTY        =-13  ;//Stream event buffer empty
TCP_NOTSUPPORTMODULE       =-14  ;//Not supported module
TCP_NOTOPEN                =-15  ;//TCPDAQ.DLL is not opened
TCP_MEMALLOCERROR          =-16  ;//Unable to allocate memory
TCP_INVALIDID              =-17  ;//illegal ID number
TCP_PINGTIMEOUT            =-18  ;//Can not ping remote IP address


// Types of EX-9017 module //
TCP_BI_10V                = 0;        // -10V~10V
TCP_BI_5V                 = 1;        // -5V~5V
TCP_BI_2Point5V           = 2;        // -2.5V~2.5V
TCP_BI_1V                 = 3;        // -1V~1V
TCP_BI_500mV              = 4;        // -500mV~500mV
TCP_BI_150mV              = 5 ;       // -150mV~150mV
TCP_BI_100mV              = 6;        // -100mV~100mV
TCP_BI_50mV               = 7 ;       // -50mV~50mV
TCP_BI_15mV               = 8;        // -15mV~ 15mV
TCP_UNI_4TO20mA           = 9;        // 4~20mA
TCP_UNI_0TO20mA           = 10;       // 0~20mA
TCP_BI_20mA               = 11;       // -20~20mA

// Types of EX-9019 module //
TCP_TypeJ                 = 14;       // TypeJ 0~760'C
TCP_TypeK                 = 15;       // TypeK 0~1370'C
TCP_TypeT                 = 16;       // TypeT -100~400'C
TCP_TypeE                 = 17;       // TypeE 0~1000'C
TCP_TypeR                 = 18;       // TypeR 500~1750'C
TCP_TypeS                 = 19;       // TypeS 500-1750'C
TCP_TypeB                 = 20;       // TypeB 500~1800'C

// Types of EX-9015  module //
TCP_PT100_50TO150A        = 32;       // PT100(a=385) 50~15'C
TCP_PT100_0TO100A         = 33;       // PT100(a=385) 0~100'C
TCP_PT100_0TO200A         = 34;       // PT100(a=385) 0~200'C
TCP_PT100_0TO400A         = 35;       // PT100(a=385) 0~400'C
TCP_PT100_200TO200A       = 36;       // PT100(a=385) -200~200'C
TCP_PT100_50TO150B        = 37;       // PT100(a=392) -50~150'C
TCP_PT100_0TO100B         = 38;       // PT100(a=392) 0~100'C
TCP_PT100_0TO200B         = 39;       // PT100(a=392) 0~200'C
TCP_PT100_0TO400B         = 40;       // PT100(a=392) 0~400'C
TCP_PT100_200TO200B       = 41;       // PT100(a=392) -200~200'C
TCP_PT1000_40TO160        = 42;       // PT1000 -40~160'C
TCP_BALCO_30TO120         = 43;       // Baclo(500) -30~100'C
TCP_NI604_80TO100         = 44;       // Ni(604 a=518) -80~100'C
TCP_NI604_0TO100          = 45;       // Ni(604 a=518) 0~100'C


//**********************************************************
//---- the functions for EX-9000 series ----
//**********************************************************
Function    TCP_GetDLLVersion    :Longint; StdCall;
procedure   TCP_Open             ;StdCall;
procedure   TCP_Close            ;StdCall;
Function    Scan_OnLineModules   (var ModuleIP : TModuleInfo;  Sortkey : Byte) :integer; StdCall;
Function    TCP_Connect          (szIP:PChar; d_port : Integer;iConnectionTimeout : Longint; iSendTimeout : Longint;iReceiveTimeout : Longint) : Longint; StdCall;
procedure   TCP_Disconnect       ;StdCall;
Function    TCP_ModuleDisconnect (szIP:PChar):Longint; StdCall;
Function    TCP_SendData         (szIP:PChar; pData : PByte;  wDataLen : Integer) : Longint; StdCall;
Function    TCP_RecvData         (szIP:PChar; pData : PByte;  wDataLen : Integer) : Longint; StdCall;
Function    TCP_SendReceiveasCcmd(szIP:PChar; TXdata :PChar;  RXata : PChar) : Longint; StdCall;
Function    TCP_GetLastError     :Longint  ; StdCall;
Function    TCP_PingIP           (szIP:PChar ;PingTimes : Integer) : Longint; StdCall;
Function    TCP_GetModuleNo      (szIP:PChar;  Mname :  PChar) : Longint; StdCall;
Function    TCP_GetModuleIPinfo  (szIP:PChar ; var ModuleIP : TModuleInfo) : Longint; StdCall;
Function    TCP_GetModuleID      (szIP:PChar ; Mname : PByte) : Longint; StdCall;
Function    TCP_GetIPFromID      (szID : Byte ; pIP :  PChar) : Longint; StdCall;
Function    TCP_StartStream      (szIP:PChar ; hEvent : Longint) : Longint; StdCall;
Function    TCP_StopStream       :Longint; StdCall;
Function    TCP_ReadStreamData   (szIP:PChar ; Var lpData : TStreamData) : integer; StdCall;
Function    TCP_StartEvent       (szIP:PChar; hEvent : Longint) : Longint; StdCall;
Function    TCP_StopEvent        :Longint; StdCall;
Function    TCP_ReadEventData    (szIP:PChar; Var lpData : TEventInfo) : integer; StdCall;
Function    TCP_ReadAllDataFromModule(szIP:PChar;  Var lpData :  TModuleData): integer; StdCall;
Function    TCP_ReadDIOMode      (szIP:PChar; byDImode : PByte;  byDOmode : PByte) : Longint; StdCall;
Function    TCP_ReadDIO          (szIP:PChar; ByDi : PByte;  ByDo : PByte) : Longint; StdCall;
Function    TCP_ReadDISignalWidth(szIP:PChar; var ulLoWidth:array of Longword;   var ulHiWidth:array of Longword) : Longint; StdCall;
Function    TCP_WriteDISignalWidth(szIP:PChar;var ulLoWidth:array of Longword;  var ulHiWidth:array of Longword) : Longint; StdCall;
Function    TCP_ReadDICounter    (szIP:PChar; var ulCounterValue:array of Longword) : Longint; StdCall;
Function    TCP_ClearDICounter   (szIP:PChar; wChno : Integer) : Longint; StdCall;
Function    TCP_StartDICounter   (szIP:PChar; wChno : Integer) : Longint; StdCall;
Function    TCP_StopDICounter    (szIP:PChar; wChno : Integer) : Longint; StdCall;
Function    TCP_ClearDILatch     (szIP:PChar; wChno : Integer) : Longint; StdCall;
Function    TCP_ReadDILatch      (szIP:PChar; wLatch : PByte) : Longint; StdCall;
Function    TCP_WriteDO          (szIP:PChar; wStartDO : Integer;  wCount : Integer;ByDo : PByte) : Longint; StdCall;
Function    TCP_WriteDOPulseCount(szIP:PChar; wDoChannel : Integer;  ulPulseCount : Longint) : Longint; StdCall;
Function    TCP_WriteDODelayWidth(szIP:PChar; wChno : Integer; ulLoPulseWidth : Longint;  ulHiPulseWidth : Longint;ulLoDelayWidth : Longint;  ulHiDelayWidth : Longint) : Longint; StdCall;
Function    TCP_ReadDODelayWidth (szIP:PChar; wChno : Integer; ulLoPulseWidth : Longint;  ulHiPulseWidth : Longint;ulLoDelayWidth : Longint;  ulHiDelayWidth : Longint) : Longint; StdCall;
Function    TCP_ReadAIValue      (szIP:PChar; dlValue : PDouble) : Longint; StdCall;
Function    TCP_ReadAITypes      (szIP:PChar; szRange : PByte) : Longint; StdCall;
Function    TCP_ReadAIMaxVal     (szIP:PChar; dMaxValue : PDouble) : Longint; StdCall;
Function    TCP_ReadAIMinVal     (szIP:PChar; dMinValue : PDouble) : Longint; StdCall;
Function    TCP_WriteAIMultiplexChannel(szIP:PChar;  szchstatus : PByte) : Longint; StdCall;
Function    TCP_ReadAIMultiplexChannel(szIP:PChar;  szchstatus : PByte) : Longint; StdCall;
Function    TCP_ReadAIAverageChannel(szIP:PChar;  szchno : PByte) : Longint; StdCall;
Function    TCP_WriteAIAverageChannel(szIP:PChar;  szchno : PByte) : Longint; StdCall;
Function    TCP_ReadAIAlarmTypes (szIP:PChar;  AIchno : Integer;  HiAlarmType : PByte;  LoAlarmType : PByte) : Longint; StdCall;
Function    TCP_WriteAIAlarmType (szIP:PChar;  Chno : Integer;  HiLoAlarm : Byte;  AlarmType : Byte) : Longint; StdCall;
Function    TCP_ReadAIAlarmDOConnection(szIP:PChar;  AIchno : Integer;  AIHiAlarmDOchn : PWORD;  AILoAlarmDOchn : PWORD) : Longint; StdCall;
Function    TCP_WriteAIAlarmDOConnection(szIP:PChar;  AIchno : Integer;  HiAlarmDOchn : PWORD;  LoAlarmDOchn : PWORD) : Longint; StdCall;
Function    TCP_ReadAIBurnOutStatus(szIP:PChar;  dlBurnout : PByte) : Longint; StdCall;
Function    TCP_ReadAIAlarmStatus(szIP:PChar;  Chno : Integer;  szHighAlarm : PByte;  szLowAlarm : PByte) : Longint; StdCall;
Function    TCP_ClearAILatchAlarm(szIP:PChar;  Chno : Integer;  alarmlevel : Byte) : Longint; StdCall;
Function    TCP_ClearAIMaxVal    (szIP:PChar;  Chno : Integer) : Longint; StdCall;
Function    TCP_ClearAIMinVal    (szIP:PChar;  Chno : Integer) : Longint; StdCall;
Function    TCP_WriteAIAlarmLimit(szIP:PChar;  Chno : Integer;  dHighLimit : Double;  dLowLimit : Double) : Longint; StdCall;
Function    TCP_ReadAIAlarmLimit (szIP:PChar;  Chno : Integer;  dHighLimit : PDouble;  dLowLimit : PDouble) : Longint; StdCall;
Function    TCP_StartAIAlarm     (szIP:PChar;  Chno : Integer;  alarmlevel : Byte) : Longint; StdCall;
Function    TCP_StopAIAlarm      (szIP:PChar;  Chno : Integer;  alarmlevel : Byte) : Longint; StdCall;
Function    TCP_WriteCJCOffset   (szIP:PChar;  CJoffset : Double) : Longint; StdCall;
Function    TCP_ReadCJCOffset    (szIP:PChar;  CJoffset : Double) : Longint; StdCall;
Function    TCP_ReadCJCTemperature(szIP:PChar;  CJTemp : PDouble) : Longint; StdCall;
Function    TCP_MODBUS_ReadCoil  (szIP:PChar;  wStartAddress : Integer;  wCount : Integer;  Data : PByte) : Longint; StdCall;
Function    TCP_MODBUS_WriteCoil (szIP:PChar;  wStartAddress : Integer;  wCount : Integer;  Data : PByte) : Longint; StdCall;
Function    TCP_MODBUS_ReadReg   (szIP:PChar;  wStartAddress : Integer;  wCount : Integer;  Data : PWord) : Longint; StdCall;
Function    TCP_MODBUS_WriteReg  (szIP:PChar;  wStartAddress : Integer;  wCount : Integer;  Data : PWord) : Longint; StdCall;
Function    UDP_Connect          (szIP:PChar;  S_Port : word;  D_Port : word;  iConnectionTimeout : Longint;iSendTimeout : Longint;  iReceiveTimeout : Longint) : Longint; StdCall;
procedure   UDP_Disconnect       ;StdCall;
Function    UDP_ModuleDisconnect (szIP:PChar) : Longint; StdCall;
Function    UDP_SendData         (szIP:PChar;  pData : PByte;  wDataLen : Integer) : Longint; StdCall;
Function    UDP_RecvData         (szIP:PChar;  pData : PByte;  wDataLen : Integer) : Longint; StdCall;
Function    UDP_SendReceiveAsCcmd(szIP:PChar;  TXdata : PChar;  RXdata : PChar) : Longint; StdCall;

implementation
//-------------------- TCP -------------------------------'
procedure   TCP_Open ;
            external 'TCPDAQ.dll' name '_TCP_Open@0' ;
procedure   TCP_Close;
            external 'TCPDAQ.dll' name '_TCP_Close@0' ;
function    TCP_Connect;
            external 'TCPDAQ.dll' name '_TCP_Connect@20';
procedure   TCP_Disconnect;
            external 'TCPDAQ.dll' name '_TCP_Disconnect@0' ;
function    TCP_ModuleDisconnect;
            external 'TCPDAQ.dll' name '_TCP_ModuleDisconnect@4' ;
function    TCP_SendData;
            external 'TCPDAQ.dll' name '_TCP_SendData@12' ;
function    TCP_RecvData;
            external 'TCPDAQ.dll' name '_TCP_RecvData@12';
function    TCP_SendReceiveASCcmd;
            external 'TCPDAQ.dll' name '_TCP_SendReceiveASCcmd@12';
//--------------------- UDP -----------------------------------------------'
function    UDP_Connect;
            external 'TCPDAQ.dll' name '_UDP_Connect@24' ;
procedure   UDP_Disconnect;
            external 'TCPDAQ.dll' name '_UDP_Disconnect@0' ;
function    UDP_ModuleDisconnect;
            external 'TCPDAQ.dll' name '_UDP_ModuleDisconnect@4' ;
function    UDP_SendData;
            external 'TCPDAQ.dll' name '_UDP_SendData@12';
function    UDP_RecvData;
            external 'TCPDAQ.dll' name '_UDP_RecvData@12' ;
function    UDP_SendReceiveASCcmd;
            external 'TCPDAQ.dll' name '_UDP_SendReceiveASCcmd@12' ;
function    TCP_GetLastError;
            external 'TCPDAQ.dll' name '_TCP_GetLastError@0' ;
function    TCP_PingIP;
            external 'TCPDAQ.dll' name '_TCP_PingIP@8' ;
//------------------- Stream -------------------------------'
function    TCP_StartStream;
            external 'TCPDAQ.dll' name '_TCP_StartStream@8';
function    TCP_StopStream;
            external 'TCPDAQ.dll' name '_TCP_StopStream@0' ;
function    TCP_ReadStreamData;
            external 'TCPDAQ.dll' name '_TCP_ReadStreamData@8' ;
//------------------- Event ----------------------------------'
function    TCP_StartEvent;
            external 'TCPDAQ.dll' name '_TCP_StartEvent@8' ;
function    TCP_StopEvent;
            external 'TCPDAQ.dll' name '_TCP_StopEvent@0' ;
function    TCP_ReadEventData;
            external 'TCPDAQ.dll' name '_TCP_ReadEventData@8' ;
//----------------- Common Module -------------------------------'
function    TCP_GetModuleIPinfo;
            external 'TCPDAQ.dll' name '_TCP_GetModuleIPinfo@8' ;
function    TCP_GetModuleID;
            external 'TCPDAQ.dll' name '_TCP_GetModuleID@8' ;
function    TCP_GetIPFromID;
            external 'TCPDAQ.dll' name '_TCP_GetIPFromID@8' ;
function    Scan_OnLineModules;
            external 'TCPDAQ.dll' name '_Scan_OnLineModules@8';
function    TCP_GetDLLVersion;
            external 'TCPDAQ.dll' name '_TCP_GetDLLVersion@0' ;
function    TCP_GetModuleNo;
            external 'TCPDAQ.dll' name '_TCP_GetModuleNo@8';
function    TCP_ReadAllDataFromModule;
            external 'TCPDAQ.dll' name '_TCP_ReadAllDataFromModule@8' ;
//----------------- DIO -------------------------------'
function    TCP_ReadDIOMode;
            external 'TCPDAQ.dll' name '_TCP_ReadDIOMode@12';
function    TCP_ReadDIO;
            external 'TCPDAQ.dll' name '_TCP_ReadDIO@12' ;
function    TCP_ReadDISignalWidth;
            external 'TCPDAQ.dll' name '_TCP_ReadDISignalWidth@12' ;
function    TCP_WriteDISignalWidth;
            external 'TCPDAQ.dll' name '_TCP_WriteDISignalWidth@12' ;
function    TCP_ReadDICounter;
            external 'TCPDAQ.dll' name '_TCP_ReadDICounter@8';
function    TCP_ClearDICounter;
            external 'TCPDAQ.dll' name '_TCP_ClearDICounter@8';
function    TCP_StartDICounter;
            external 'TCPDAQ.dll' name '_TCP_StartDICounter@8' ;
function    TCP_StopDICounter;
            external 'TCPDAQ.dll' name '_TCP_StopDICounter@8';
function    TCP_ClearDILatch;
            external 'TCPDAQ.dll' name '_TCP_ClearDILatch@8';
function    TCP_ReadDILatch;
            external 'TCPDAQ.dll' name '_TCP_ReadDILatch@8' ;
function    TCP_WriteDO;
            external 'TCPDAQ.dll' name '_TCP_WriteDO@16' ;
function    TCP_WriteDOPulseCount;
            external 'TCPDAQ.dll' name '_TCP_WriteDOPulseCount@12';
function    TCP_WriteDODelayWidth;
            external 'TCPDAQ.dll' name '_TCP_WriteDODelayWidth@24' ;
function    TCP_ReadDODelayWidth;
            external 'TCPDAQ.dll' name '_TCP_ReadDODelayWidth@24';
//---------------------- AIO  ----------------------------------------------'
function    TCP_WriteAIAlarmType;
            external 'TCPDAQ.dll' name '_TCP_WriteAIAlarmType@16';
function    TCP_ReadAIValue;
            external 'TCPDAQ.dll' name '_TCP_ReadAIValue@8';
function    TCP_ReadAITypes;
            external 'TCPDAQ.dll' name '_TCP_ReadAITypes@8' ;
function    TCP_ReadAIMaxVal;
            external 'TCPDAQ.dll' name '_TCP_ReadAIMaxVal@8' ;
function    TCP_ReadAIMinVal;
            external 'TCPDAQ.dll' name '_TCP_ReadAIMinVal@8';
function    TCP_WriteAIMultiplexChannel;
            external 'TCPDAQ.dll' name '_TCP_WriteAIMultiplexChannel@8' ;
function    TCP_ReadAIMultiplexChannel;
            external 'TCPDAQ.dll' name '_TCP_ReadAIMultiplexChannel@8';
function    TCP_ReadAIAverageChannel;
            external 'TCPDAQ.dll' name '_TCP_ReadAIAverageChannel@8' ;
function    TCP_WriteAIAverageChannel;
            external 'TCPDAQ.dll' name '_TCP_WriteAIAverageChannel@8';
function    TCP_ReadAIAlarmTypes;
            external 'TCPDAQ.dll' name '_TCP_ReadAIAlarmTypes@16';
function    TCP_ReadAIAlarmDOConnection;
            external 'TCPDAQ.dll' name '_TCP_ReadAIAlarmDOConnection@16';
function    TCP_WriteAIAlarmDOConnection;
            external 'TCPDAQ.dll' name '_TCP_WriteAIAlarmDOConnection@16' ;
function    TCP_ReadAIAlarmStatus;
            external 'TCPDAQ.dll' name '_TCP_ReadAIAlarmStatus@16';
function    TCP_ClearAILatchAlarm;
            external 'TCPDAQ.dll' name '_TCP_ClearAILatchAlarm@12' ;
function    TCP_ClearAIMaxVal;
            external 'TCPDAQ.dll' name '_TCP_ClearAIMaxVal@8';
function    TCP_ClearAIMinVal;
            external 'TCPDAQ.dll' name '_TCP_ClearAIMinVal@8' ;
function    TCP_ReadAIBurnOutStatus;
            external 'TCPDAQ.dll' name '_TCP_ReadAIBurnOutStatus@8' ;
function    TCP_WriteAIAlarmLimit;
            external 'TCPDAQ.dll' name '_TCP_WriteAIAlarmLimit@24' ;
function    TCP_ReadAIAlarmLimit;
            external 'TCPDAQ.dll' name '_TCP_ReadAIAlarmLimit@16' ;
function    TCP_StartAIAlarm;
            external 'TCPDAQ.dll' name '_TCP_StartAIAlarm@12' ;
function    TCP_StopAIAlarm;
            external 'TCPDAQ.dll' name '_TCP_StopAIAlarm@12' ;
function    TCP_WriteCJCOffset;
            external 'TCPDAQ.dll' name '_TCP_WriteCJCOffset@12';
function    TCP_ReadCJCOffset;
            external 'TCPDAQ.dll' name '_TCP_ReadCJCOffset@8' ;
function    TCP_ReadCJCTemperature;
            external 'TCPDAQ.dll' name '_TCP_ReadCJCTemperature@8' ;
//---------------------- TCP/IP MODBUS  ---------------------------------------------------------'
function    TCP_MODBUS_ReadCoil;
            external 'TCPDAQ.dll' name '_TCP_MODBUS_ReadCoil@16' ;
function    TCP_MODBUS_WriteCoil;
            external 'TCPDAQ.dll' name '_TCP_MODBUS_WriteCoil@16' ;
function    TCP_MODBUS_ReadReg;
            external 'TCPDAQ.dll' name '_TCP_MODBUS_ReadReg@16' ;
function    TCP_MODBUS_WriteReg;
            external 'TCPDAQ.dll' name '_TCP_MODBUS_WriteReg@16';


end.