VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Read DI counter for 9000 Series:"
   ClientHeight    =   4785
   ClientLeft      =   2610
   ClientTop       =   2340
   ClientWidth     =   6810
   LinkTopic       =   "Form1"
   ScaleHeight     =   4785
   ScaleWidth      =   6810
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   200
      Left            =   3105
      Top             =   135
   End
   Begin VB.Frame Frame1 
      Height          =   3735
      Left            =   2880
      TabIndex        =   1
      Top             =   495
      Width           =   3780
      Begin VB.CommandButton cmdRead 
         Caption         =   "Start"
         Height          =   540
         Left            =   360
         TabIndex        =   10
         Top             =   2835
         Width           =   1305
      End
      Begin VB.CommandButton cmdExit 
         Caption         =   "E&xit"
         Height          =   540
         Left            =   1980
         TabIndex        =   9
         Top             =   2835
         Width           =   1305
      End
      Begin VB.TextBox txtVersion 
         Height          =   360
         Left            =   1920
         Locked          =   -1  'True
         TabIndex        =   7
         Text            =   "Text1"
         Top             =   1920
         Width           =   1335
      End
      Begin VB.TextBox txtID 
         Height          =   360
         Left            =   1890
         Locked          =   -1  'True
         TabIndex        =   6
         Top             =   1215
         Width           =   1305
      End
      Begin VB.TextBox txtIPAddress 
         BackColor       =   &H0080FFFF&
         Height          =   390
         Left            =   1920
         TabIndex        =   3
         Text            =   "192.168.0.80"
         Top             =   480
         Width           =   1350
      End
      Begin VB.Label Label6 
         Caption         =   "The DLL Version:"
         Height          =   255
         Left            =   135
         TabIndex        =   8
         Top             =   1980
         Width           =   1455
      End
      Begin VB.Label Label5 
         Caption         =   "Device ID :"
         Height          =   240
         Left            =   180
         TabIndex        =   5
         Top             =   1305
         Width           =   1665
      End
      Begin VB.Label Label3 
         Caption         =   "IP Address :"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   600
         Width           =   1440
      End
   End
   Begin VB.TextBox txtDIMsg 
      Height          =   3585
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   600
      Width           =   2610
   End
   Begin VB.Label Label1 
      Caption         =   "The DI channel(s) should be configured as Counter mode by Utility"
      Height          =   285
      Left            =   135
      TabIndex        =   11
      Top             =   4320
      Width           =   4830
   End
   Begin VB.Label Label4 
      Caption         =   "Digital Input Counter Value:"
      Height          =   255
      Left            =   135
      TabIndex        =   4
      Top             =   315
      Width           =   2160
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'-------------------- demo ------------------------------------
Option Explicit
Dim ConnectionTimeout As Long
Dim SendTimeout As Long
Dim ReceiveTimeout  As Long
Dim IPaddress As String
    Dim ReturnValue As Long
Private Sub cmdExit_Click()
'--- Disconnect to EX-9000 ---
   Timer1.Enabled = False
   TCP_Disconnect
   TCP_Close
   Unload Me
End Sub

Private Sub cmdRead_Click()
   Dim i%, j%
   Dim wStartAddress%, wCount%
   Dim sock As Long
    
'---  The module's IP address of EX-9000  ---
   IPaddress = Space(80)
   IPaddress = txtIPAddress.Text
    
'-------- Set timeout value ------
   ConnectionTimeout = 2000
   SendTimeout = 2000
   ReceiveTimeout = 2000
    
'--- Connect to EX-9000 ---
   ReturnValue = TCP_Connect(IPaddress, ModbusTCPPort, ConnectionTimeout, SendTimeout, ReceiveTimeout)
   If ReturnValue Then
       Beep
       MsgBox "Can't connect to " + txtIPAddress
       Exit Sub
   End If
    
'---- Get Moduel ID---
   Dim Id As Byte
   ReturnValue = TCP_GetModuleID(IPaddress, Id)
   txtID.Text = Id

    
'---- start to read counter value per 200 msec ----

   'Enable DI counter before reading counter value
   For i = 0 To 11   'EX 9050 has 12 counter
         ReturnValue = TCP_StartDICounter(IPaddress, i)
   Next
    
   Timer1.Enabled = True
    

End Sub

Private Sub Form_Activate()
txtIPAddress.SetFocus
End Sub

Private Sub Form_Load()

'--- Initial DLL to working ---
    ReturnValue = TCP_GetDLLVersion()
    txtVersion.Text = Hex(ReturnValue)
    szSend = Space(150)
    szReceive = Space(150)
    TCP_Open

End Sub



Private Sub Timer1_Timer()

'---Start to read DI counter---
   Dim i As Long
   Dim Msg$, A$
    
   'EX9050 has 12 DI counter
   Dim CounterValue(11) As Long

   'Call  TCP_ReadDICounter() in TCPDAQ.dll
   ReturnValue = TCP_ReadDICounter(IPaddress, CounterValue(0))
    
   'Error code ?
   If ReturnValue Then
       Beep
       MsgBox "TCP_ReadDICounter() Failure !"
       Exit Sub
   End If

   Msg$ = ""
    
   'Dislay Counter value start from counter 0 to counter 11
   For i = 0 To 11
       A$ = "Counter:" & Format(i, "00") & "   ->  " & Format(CounterValue(i), "00000") & vbCrLf
       Msg$ = Msg$ & A$
       txtDIMsg.Text = Msg$
   Next i

End Sub
