// AlarmEventDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AlarmEvent.h"
#include "AlarmEventDlg.h"

#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

UINT ThreadProc( LPVOID lpParam );

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char			szIPAddress[20];
static int		iTotalReceive;
static int		iTotalTimeout;
static int		iThreadIndex;
//----------------------------------------------
struct _AlarmInfo   *pAlarmData,AlarmData;
static BYTE byLoopFlag=1;
HANDLE    hEvent;
/////////////////////////////////////////////////////////////////////////////
// CAlarmEventDlg dialog

CAlarmEventDlg::CAlarmEventDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAlarmEventDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAlarmEventDlg)
	m_strIPAddress = _T("");
	//m_strStartAddress = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAlarmEventDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAlarmEventDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	//DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAlarmEventDlg, CDialog)
	//{{AFX_MSG_MAP(CAlarmEventDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_STOP, OnStop)
	ON_BN_CLICKED(ID_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlarmEventDlg message handlers

BOOL CAlarmEventDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.15";
	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

	// get the DLL version
	char   szCh[20];
    int    iVersion;

	iVersion=TCP_GetDLLVersion();
	_ltoa( iVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    //--- To initialize DLL to work ---
    int   tcp_err;

    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        MessageBox("TCP_Open() Failure !!!");
    }

    (CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAlarmEventDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAlarmEventDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAlarmEventDlg::OnExit()
{
    //--- Finally, calling TCP_Close() to release all allocated resource  ---
    TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();

}

void CAlarmEventDlg::OnStart()
{
	int       tcp_erre;
   CString   strText,strTemp;

	(CButton *)GetDlgItem(ID_START)->EnableWindow( FALSE );
	(CButton *)GetDlgItem(ID_STOP)->EnableWindow( TRUE );

	m_bStopThread = FALSE;
	m_pThread = NULL;

   m_iTotalReceive=0;
   m_iTotalTimeout=0;
   m_iThreadIndex=0;

   // get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
   //MessageBox( szIPAddress);

   //-----  create a event for synchronization ---------------
   hEvent = CreateEvent(NULL,
			     FALSE,   // auto reset
			     FALSE,  // init state as Non-Signal
			     NULL);

	((CListBox*)GetDlgItem(IDC_LIST_STREAM))->ResetContent();
    m_pListBox=(CListBox*)GetDlgItem(IDC_LIST_STREAM);

	if( m_pThread == NULL )
	{
		m_ThreadData.hEvent = &hEvent;
		m_ThreadData.lpStopThread = &m_bStopThread;
		m_ThreadData.TotalReceive=&m_iTotalReceive;
      m_ThreadData.TotalTimeout=&m_iTotalTimeout;
      m_ThreadData.ThreadIndex=&m_iThreadIndex;
		m_ThreadData.pListBox=m_pListBox;

      // Start the thread.
		m_pThread =AfxBeginThread(ThreadProc, (LPVOID) &m_ThreadData);
	}

    //--- Starting to receive the streaming data come from EX-9000MTCP ---
    tcp_erre=TCP_StartEvent(szIPAddress,hEvent);
    if( tcp_erre<0 )
    {
		MessageBox("TCP_StartStream() Failure !!!");
    }

}

void CAlarmEventDlg::OnStop()
{
 	// TODO: Add your control notification handler code here
	HANDLE hThread = m_pThread->m_hThread;

	// Set the flag to kill the thread to TRUE;
    m_bStopThread = TRUE;

	// Wait for the thread to end.
	::WaitForSingleObject( hThread, 1000 );

    //------ Stop receiving the stream data come from EX-9000MTCP ------
	TCP_StopEvent( );
    //------ Close the event handle ------
    CloseHandle(hEvent);

	(CButton *)GetDlgItem(ID_START)->EnableWindow( TRUE );
	(CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );

    m_iTotalReceive=0;
    m_iTotalTimeout=0;
    m_iThreadIndex=0;
}

UINT ThreadProc( LPVOID lpParam )
{
	THREAD_DATA *lpThreadData =(THREAD_DATA *) lpParam;
	int    tcp_erre;
    CString   strText;


	//------Print the AlarmData's value-----
	while( !(*lpThreadData->lpStopThread) )
	{
		*lpThreadData->ThreadIndex=101;
	    if(WaitForSingleObject(*lpThreadData->hEvent,3000)==WAIT_OBJECT_0)  // waiting for 3 seconds
	    {
				if( (*lpThreadData->TotalReceive)%7==6 )
				{
				   (lpThreadData->pListBox)->ResetContent();
				}

				(*lpThreadData->TotalReceive)++;
				tcp_erre=TCP_ReadEventData(szIPAddress,&AlarmData);
				pAlarmData=(struct _AlarmInfo *)&AlarmData;


				strText.Format( "Receive:%d", *lpThreadData->TotalReceive);
				(lpThreadData->pListBox)->InsertString( -1, strText );

				//------Print the DI/O's value------
				strText.Format("The Alarm IP=%s: ",szIPAddress); //  THE DO Value=%03x\n",pAlarmData->DIN,pAlarmData->DOUT);
				(lpThreadData->pListBox)->InsertString( -1, strText );

				//------Print Module's IP------
				strText.Format("Alarm Channel=%d ", pAlarmData->byChannel);
				(lpThreadData->pListBox)->InsertString(-1,strText);

				strText.Format("Alarm Status=%d ", pAlarmData->byAlarmStatus);
				(lpThreadData->pListBox)->InsertString(-1,strText);

				strText.Format("Alarm Type=%d ", pAlarmData->byAlarmType);
				(lpThreadData->pListBox)->InsertString(-1,strText);

				strText.Format("Alarm Value=%00004X ", pAlarmData->wValue);
				(lpThreadData->pListBox)->InsertString(-1,strText);

            //------Print time------
				strText.Format("Time %d/%d/%d %d:%d:%d",pAlarmData->szDateTime[0],pAlarmData->szDateTime[1],
														pAlarmData->szDateTime[2],pAlarmData->szDateTime[3],
														pAlarmData->szDateTime[4],pAlarmData->szDateTime[5]);
				(lpThreadData->pListBox)->InsertString(-1,strText);
		}
		else
		{
			(*lpThreadData->TotalTimeout)++;
		}

	}
	(*lpThreadData->ThreadIndex)=102;
	return 0;
}

/*   u_char   szIP[4];       //The IP address which cause the alarm change
   u_short  szDateTime[6]; //E.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
   u_short  byChannel;     //The Channel of which cause the alarm change
   u_short  byAlarmType;   //0x00:AIO Low Alarm
                           //0x01:AIO High Alarm
                           //0x20:DIO Alarm
                           //0xF0:Connection Alarm
   u_short  byAlarmStatus; //0:Alarm ON to OFF, 1:Alarm OFF to ON
   u_short  wValue;        //Alarm value.For DIO, this value could be "0" or "1" means that "ON" or "OFF"
                           //            For high or low alarm, this is the AIO value.
                           //            For connection lost, this value is 0.
};*/
