// coilrdDlg.cpp : implementation file
//

#include "stdafx.h"
#include "coilrd.h"
#include "coilrdDlg.h"

#include <winsock2.h>
#include "..\..\..\include\TcpDAQ.h"


#define DEFAULT_PORT 502   // Modbus/TCP's Port
#define DeviceID     0x01  // 0x01 indicate the EX-9000MTCP's ID

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoilrdDlg dialog

CCoilrdDlg::CCoilrdDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCoilrdDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCoilrdDlg)
	m_strIPAddress = _T("");
	m_strStartAddress = _T("");
	m_strNoOfRead = _T("");
	m_strDeviceID = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCoilrdDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCoilrdDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	DDX_Text(pDX, IDC_EDIT_NO, m_strNoOfRead);
	DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCoilrdDlg, CDialog)
	//{{AFX_MSG_MAP(CCoilrdDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_READCOIL, OnReadcoil)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoilrdDlg message handlers

BOOL CCoilrdDlg::OnInitDialog()
{
	int    iRetVal;
	char   szDump[80];

	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.52";
//	m_strDeviceID="1";
	m_strStartAddress="1";
	m_strNoOfRead="16";

	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);
	SetDlgItemText(IDC_EDIT_DEVICEID,m_strDeviceID);
	SetDlgItemText(IDC_EDIT_STARTADDRESS,m_strStartAddress);
	SetDlgItemText(IDC_EDIT_NO,m_strNoOfRead);

	// get the DLL version 
	char   szCh[20];
    int    iVersion;    
 
	iVersion=TCP_GetDLLVersion();
	_ltoa( iVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    //--- Firstly, initial DLL to working ---
    iRetVal=TCP_Open();
    if( iRetVal!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",iRetVal);
        MessageBox(szDump);
    }
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCoilrdDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCoilrdDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCoilrdDlg::OnExit() 
{
    //--- Finally, release some resource that DLL allocated---
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();	
}

void CCoilrdDlg::OnReadcoil() 
{
	// TODO: Add your control notification handler code here
    CString   strText,strTemp;
	char      szIPAddress[20];
	int       i,j,tcp_err;
	WORD      wDeviceID;
    WORD      wStartAddress;
    WORD      wCount;
    BYTE      byData[128];
	char      szDump[80];

   // Number of coils to read
	GetDlgItemText(IDC_EDIT_NO,strTemp);
	wCount=atoi(strTemp);
	if( wCount<0 || wCount>128 )
	{
		MessageBox("The # of Coil must between 1 to 128 !");
		return;
	}

	// Device ID
	GetDlgItemText(IDC_EDIT_DEVICEID,strTemp);
	wDeviceID=atoi(strTemp);

	// Start address to read
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

    // Get the EX-9000MTCP's IP 
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//--- Connect to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);

    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        return;
    }

   //-- Get Module name ---//
    char   szMoudleNo[20];
    tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
    SetDlgItemText(IDC_NAME, szMoudleNo);

   //-- Get Id number ---//
   char  IDno, szId[20];
   TCP_GetModuleID(szIPAddress,&IDno);
   sprintf (szId,"%d",IDno);
   SetDlgItemText(IDC_EDIT_DEVICEID, szId);


    //--- Reading the coil's registers ---
	tcp_err=TCP_MODBUS_ReadCoil(szIPAddress,wStartAddress,wCount,byData);
    
    if( tcp_err )
    {
        sprintf(szDump,"TCP_ReadCoil() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

	((CListBox*)GetDlgItem(IDC_LIST_COILVALUE))->ResetContent();
	for(i=0,j=wStartAddress; i<wCount; i++,j++)
	{
		strText.Format( "Address:%d   Value:%d", j,byData[i]);
		((CListBox*)GetDlgItem(IDC_LIST_COILVALUE))->InsertString( -1, strText );
	}

    //--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();

}
