// RegReadDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RegRead.h"
#include "RegReadDlg.h"

#include "..\..\..\include\tcpdaq.h"

#define DEFAULT_PORT	502  // Port for Modbus/TCP
//-------- default timeout ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegReadDlg dialog

CRegReadDlg::CRegReadDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegReadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegReadDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_strNoOfRead = _T("1");
	m_strIPAddress = _T("192.168.0.15");
	m_strStartAddress = _T("1");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
   
   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRegReadDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegReadDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Text(pDX, IDC_EDIT_NOOFREAD, m_strNoOfRead);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegReadDlg, CDialog)
	//{{AFX_MSG_MAP(CRegReadDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_READREGISTER, OnReadregister)
	ON_BN_CLICKED(ID_EXIT, OnExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegReadDlg message handlers

BOOL CRegReadDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
    //--- Firstly, initial DLL to working ---
   int iRetVal;
    char   szDump[80];
	int  DllVersion;
    iRetVal=TCP_Open();
    if( iRetVal!=0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",iRetVal); 
       MessageBox( szDump );
       return TRUE;
    }
	DllVersion=TCP_GetDLLVersion();
	_ltoa( DllVersion, szDump, 16 );
   SetDlgItemText(IDC_EDIT_DLLVERSION, szDump);

   
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRegReadDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRegReadDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CRegReadDlg::OnReadregister() 
{
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	char      szIPAddress[20];
	int       i,j,tcp_err;
   WORD      wStartAddress;
   WORD      wCount;
   WORD      wData[64];  
	char      szDump[80];

	// How many registers to read
	GetDlgItemText(IDC_EDIT_NOOFREAD,strTemp);
	wCount=atoi(strTemp);
	if( wCount<1 || wCount>64 )
	{
		MessageBox("The # of Coil must between 1 to 64 !");
		return;
	}

	// the start address to read
	//-- Notice: the address start at 1 instead of 40001
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

    //--- Get the EX-9000MTCP's IP ---
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//---Connection to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,
				  iConnectionTimeout, iSendTimeout, iReceiveTimeout);
    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
		TCP_Disconnect();
        return;
    }

    char   szMoudleNo[20];
    tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
    SetDlgItemText(IDC_EDIT_NAME, szMoudleNo);

   //-- Get Id number ---//
   char  IDno, szId[20];
   TCP_GetModuleID(szIPAddress,&IDno);
   sprintf (szId,"%d",IDno);
   SetDlgItemText(IDC_EDIT_DEVICEID, szId);

    //--- Reading the registers ---
	tcp_err=TCP_MODBUS_ReadReg(szIPAddress,wStartAddress,wCount,wData);
    if( tcp_err )
    {
		sprintf(szDump,"TCP_ReadReg() Failure !!!   code=%d\n",tcp_err);
        MessageBox( szDump );
        TCP_Disconnect();
        return;
    }

	((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->ResetContent();
	for(i=0,j=wStartAddress; i<wCount; i++,j++)
	{
		strText.Format( "Address:%d   Value(Dec):%d   Value(Hex):%04x", j,wData[i],wData[i]);
		((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->InsertString( -1, strText );
	}

    //--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();
	
}

void CRegReadDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	TCP_Close();
  	CDialog::OnOK();

}
