// RegWriteDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RegWrite.h"
#include "RegWriteDlg.h"
#include "..\..\..\Include\tcpdaq.h"

#define DEFAULT_PORT 502   // Modbus/TCP's Port
//-------- default timeout ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegWriteDlg dialog

CRegWriteDlg::CRegWriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRegWriteDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRegWriteDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_strData0 = _T("255");
	m_strData1 = _T("255");
	m_strData2 = _T("255");
	m_strData3 = _T("255");
	m_strData4 = _T("255");
	m_strData5 = _T("255");
	m_strData6 = _T("255");
	m_strData7 = _T("255");
	m_strData8 = _T("255");
	m_strData9 = _T("255");
	m_strData10 = _T("255");
	m_strData11 = _T("255");
	m_strData12 = _T("255");
	m_strData13 = _T("255");
	m_strData14 = _T("255");
	m_strData15 = _T("255");
	m_strIPAddress = _T("192.168.0.15");
	m_strNoOfWrite = _T("1");
	m_strStartAddress = _T("0");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}
CRegWriteDlg::~CRegWriteDlg()
{
    // finally, release some resource allocated by DLL
	TCP_Close();
}


void CRegWriteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRegWriteDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Text(pDX, IDC_DATA0, m_strData0);
	DDX_Text(pDX, IDC_DATA1, m_strData1);
	DDX_Text(pDX, IDC_DATA2, m_strData2);
	DDX_Text(pDX, IDC_DATA3, m_strData3);
	DDX_Text(pDX, IDC_DATA4, m_strData4);
	DDX_Text(pDX, IDC_DATA5, m_strData5);
	DDX_Text(pDX, IDC_DATA6, m_strData6);
	DDX_Text(pDX, IDC_DATA7, m_strData7);
	DDX_Text(pDX, IDC_DATA8, m_strData8);
	DDX_Text(pDX, IDC_DATA9, m_strData9);
	DDX_Text(pDX, IDC_DATA10, m_strData10);
	DDX_Text(pDX, IDC_DATA11, m_strData11);
	DDX_Text(pDX, IDC_DATA12, m_strData12);
	DDX_Text(pDX, IDC_DATA13, m_strData13);
	DDX_Text(pDX, IDC_DATA14, m_strData14);
	DDX_Text(pDX, IDC_DATA15, m_strData15);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_NOOFWRITE, m_strNoOfWrite);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegWriteDlg, CDialog)
	//{{AFX_MSG_MAP(CRegWriteDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_WRITEREGISTER, OnWriteregister)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRegWriteDlg message handlers

BOOL CRegWriteDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	char   szDump[20];
 
    if( TCP_Open()!=0 )
    {
       sprintf(szDump,"TCP_Open() Failure !!!\n"); 
       MessageBox( szDump );
    }
   
    char   szCh[10];
    int    DLLVersion;
   
    DLLVersion=TCP_GetDLLVersion();
    _ltoa( DLLVersion, szCh, 16 );
    SetDlgItemText(IDC_EDIT_DLLVERSION, szCh);

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRegWriteDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRegWriteDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CRegWriteDlg::OnWriteregister() 
{
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	char      szIPAddress[20],szTemp[10],*stopstring;
	int       i,tcp_err,nID;
   WORD      wDeviceID;
	WORD      wStartAddress;
   WORD      wCount;
   WORD      wData[64];  
   char      szDump[80];

	// Number of registers to write
	GetDlgItemText(IDC_EDIT_NOOFWRITE,strTemp);
	wCount=atoi(strTemp);
	if( wCount<0 || wCount>16 )
	{
		MessageBox("The # of register must between 1 to 16 !");
		return;
	}

	//---Device ID ---
	GetDlgItemText(IDC_EDIT_DEVICEID,strTemp);
	wDeviceID=atoi(strTemp);

	//--- Start address to write ---
	//--- Notice: the address start at 1 instead of 40001
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

    // Get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//--- Connect to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);

    if(  tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   Error code=%d\n", tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }
   //-- Get Module name ---//
    char   szMoudleNo[20];
    tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
    SetDlgItemText(IDC_EDIT_NAME, szMoudleNo);

   //-- Get Id number ---//
   char  IDno, szId[20];
   TCP_GetModuleID(szIPAddress,&IDno);
   sprintf (szId,"%d",IDno);
   SetDlgItemText(IDC_EDIT_DEVICEID, szId);

    //--- Set the data for writing to EX-9000MTCP ---
	nID=IDC_DATA0;
	for(i=0; i<16; i++)
	{
		GetDlgItemText(nID+i,strTemp);
		strcpy(szTemp,strTemp.GetBuffer(10));
		wData[i]=(WORD)strtol(szTemp, &stopstring, 16);
	}
    
	//------ Writng the registers ------
	
    tcp_err=TCP_MODBUS_WriteReg(szIPAddress,wStartAddress,wCount,wData);
    if( tcp_err )
    {
        sprintf(szDump,"TCP_WriteReg() Failure !!!   Error code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

    //--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();
	
}

void CRegWriteDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	   TCP_Close();

   // TODO: Add your control notification handler code here
   CDialog::OnOK();

}
