// PerfTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PerfTest.h"
#include "PerfTestDlg.h"

#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

#define DEFAULT_PORT 502   // Modbus/TCP's Port
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPerfTestDlg dialog

CPerfTestDlg::CPerfTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPerfTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPerfTestDlg)
	m_strIPAddress = _T("");
	m_strStartAddress = _T("");
	m_strNoOfRead = _T("");
	m_strDeviceID = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPerfTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPerfTestDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_STARTADDRESS, m_strStartAddress);
	DDX_Text(pDX, IDC_EDIT_NOOFREAD, m_strNoOfRead);
	DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPerfTestDlg, CDialog)
	//{{AFX_MSG_MAP(CPerfTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_READREGISTER, OnReadregister)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPerfTestDlg message handlers

BOOL CPerfTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.15";
	m_strStartAddress="1";
	m_strNoOfRead="16";

	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);
	SetDlgItemText(IDC_EDIT_DEVICEID,m_strDeviceID);
	SetDlgItemText(IDC_EDIT_STARTADDRESS,m_strStartAddress);
	SetDlgItemText(IDC_EDIT_NOOFREAD,m_strNoOfRead);

	// Read the DLL version 
	char   szCh[20],szDump[50];
    int   tcp_err,DLLVersion;    
 
	DLLVersion=TCP_GetDLLVersion();
	_ltoa( DLLVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVERSION, szCh);

    //--- Initial DLL to working ----
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPerfTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPerfTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPerfTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CPerfTestDlg::OnExit() 
{
    //--- Finally, release some resource that DLL allocated---
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();	
	
}

void CPerfTestDlg::OnReadregister() 
{
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	char      szIPAddress[20];
	int       i,j,tcp_err;
   WORD      wStartAddress;
   WORD      wCount;
   WORD      wData[64];  
	char      szDump[80];
	long      lNowTick,lEndTick;
	int       iTotalCount;


	// Number of registers to read
	GetDlgItemText(IDC_EDIT_NOOFREAD,strTemp);
	wCount=atoi(strTemp);
	if( wCount<0 || wCount>64 )
	{
		MessageBox("The # of Coil must between 1 to 64 !");
		return;
	}


	// Start address to read
	//-- Notice: the address start at 1 instead of 40001
	GetDlgItemText(IDC_EDIT_STARTADDRESS,strTemp);
	wStartAddress=atoi(strTemp);

    // Get the EX-9000MTCP's IP 
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//--- Connect to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
		TCP_Disconnect();
        return;
    }

    //--- Testing for reading the registers ---
    ((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->ResetContent();
    iTotalCount=0;
	lEndTick=GetTickCount()+5000;
	do
	{
       tcp_err=TCP_MODBUS_ReadReg(szIPAddress, wStartAddress, wCount, wData);
       if( tcp_err )
	   {
	  	  sprintf(szDump,"TCP_ReadReg() Failure !!!   code=%d\n",tcp_err);
          MessageBox( szDump );
          TCP_Disconnect();
          return;
	   }
	   lNowTick=GetTickCount();
	   iTotalCount++;
	}while( lNowTick<lEndTick );
	iTotalCount/=5;

	strText.Format("Reading register %d times per seconds.",iTotalCount);
	((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->InsertString( -1, strText );

	for(i=0,j=wStartAddress; i<wCount; i++,j++)
	{
		strText.Format( "Address:%d   Value(Dec):%d   Value(Hex):%04x", j,wData[i],wData[i]);
		((CListBox*)GetDlgItem(IDC_LIST_REGISTERVALUE))->InsertString( -1, strText );
	}

	//--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();	
}
