// PingIPDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PingIP.h"
#include "PingIPDlg.h"
#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"
#define DEFAULT_PORT 502   // Modbus/TCP's Port
//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPingIPDlg dialog

CPingIPDlg::CPingIPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPingIPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPingIPDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_strIPAddress = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPingIPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPingIPDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPingIPDlg, CDialog)
	//{{AFX_MSG_MAP(CPingIPDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PignIP, OnPignIP)
	ON_BN_CLICKED(IDC_Exit, OnExit)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPingIPDlg message handlers

BOOL CPingIPDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	char   szDump[40];
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	m_strIPAddress="192.168.0.52";
	SetDlgItemText(IDC_ModuleIP,m_strIPAddress);
	// TODO: Add extra initialization here
	char   szCh[10];
   int    DLLVersion;    
 
	DLLVersion=TCP_GetDLLVersion();
	_ltoa( DLLVersion, szCh, 16 );
	SetDlgItemText(IDC_DLLVersion, szCh);
	int tcp_err;
    //Initial DLL to working ---
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPingIPDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPingIPDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

int count=0;

void CPingIPDlg::OnPignIP() 
{
	// TODO: Add your control notification handler code here
	CString   strText,strTemp;
	char      szIPAddress[20];
	int       tcp_err,	PingEchoTime;
	char      szDump[80];
	int	    Timeout=5000;// set Timeout 5 sec
	

	GetDlgItemText(IDC_ModuleIP,szIPAddress,20);

    //--- Connect to EX-9000MTCP ---
	tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
		sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        return;
    }
	count++;
	if(count%8==0)
		((CListBox*)GetDlgItem(IDC_LIST))->ResetContent();
	PingEchoTime=TCP_PingIP( szIPAddress,Timeout);
	if(	PingEchoTime<00 )
	{
		sprintf(szDump,"No Reponse from remote IP !!! \n");
		MessageBox(szDump);
	   return;
	}
	strText.Format( "ping IP %s  Response Time=%d", szIPAddress,	PingEchoTime);
	((CListBox*)GetDlgItem(IDC_LIST))->InsertString( -1, strText );
	//--- Disconnect to EX-9000MTCP ---
	TCP_Close();
	
}

void CPingIPDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();
	
}


