// ReadAIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReadAI.h"
#include "ReadAIDlg.h"

#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

#define DEFAULT_PORT 502   // Modbus/TCP's Port

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyReadAIDlg dialog

CMyReadAIDlg::CMyReadAIDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMyReadAIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyReadAIDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_strIPAddress = _T("");
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyReadAIDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyReadAIDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP	
	DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
}

BEGIN_MESSAGE_MAP(CMyReadAIDlg, CDialog)
	//{{AFX_MSG_MAP(CMyReadAIDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_ANALOGINPUT, OnAnaloginput)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyReadAIDlg message handlers

BOOL CMyReadAIDlg::OnInitDialog()
{
	int    tcp_err;
	char   szDump[80];

	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.15";

    SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);
	SetDlgItemText(IDC_EDIT_DEVICEID,m_strDeviceID);

	// get the DLL version 
	char   szCh[20];
    int    iVersion;    
 
	iVersion=TCP_GetDLLVersion();
	_ltoa( iVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    //--- Firstly, initial DLL to working ---
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyReadAIDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyReadAIDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMyReadAIDlg::OnExit() 
{
    //--- Finally, release some resource that DLL allocated---
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();		
}

void CMyReadAIDlg::OnAnaloginput() 
{
	// TODO: Add your control notification handler code here
    CString   strText,strTemp;
	char      szIPAddress[20];
	int       i,tcp_err, iChannel;
	char      szDump[80];
	
    //--- Notice: support 9015,9017,9019 in DLL Ver 102 ---

    // Get the EX-9000MTCP's IP Address
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//create a connection to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,
				  iConnectionTimeout, iSendTimeout, iReceiveTimeout);

    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        return;
    }

	//-- Get Id number ---//
	char  IDno, szId[20];
    TCP_GetModuleID(szIPAddress,&IDno);
	sprintf (szId,"%d",IDno);
	SetDlgItemText(IDC_EDIT_DEVICEID, szId);
	
	//-- Get Module name ---//
    char   szMoudleNo[20];
    tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
	SetDlgItemText(IDC_NAME, szMoudleNo);

   iChannel = 7;
   double dlValue[50];

    //--- reading AI value ---
    tcp_err=TCP_ReadAIValue(szIPAddress, dlValue);
    if( tcp_err )
    {
        sprintf(szDump,"TCP_ReadAIValue() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }
	//----- Display the Analog Input value for channel 0 to 7 -------
	((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->ResetContent();
	for(i=0; i<iChannel; i++)
	{
		strText.Format( "Channel:%02d  Value:%5.3f", i,dlValue[i]);
		((CListBox*)GetDlgItem(IDC_LIST_AIVALUE))->InsertString( -1, strText );
	}
	//--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();
	
}