// ReadDIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "ReadDIO.h"
#include "ReadDIODlg.h"
#include <winsock2.h>
#include "..\..\..\include\TCPDAQ.H"

#define DEFAULT_PORT 502   // Modbus/TCP's Port

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CMyReadDIODlg dialog

CMyReadDIODlg::CMyReadDIODlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMyReadDIODlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMyReadDIODlg)
      // NOTE: the ClassWizard will add member initialization here
   m_strIPAddress = _T("");
   //}}AFX_DATA_INIT
   // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
   m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyReadDIODlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
 //  DDX_Text(pDX, IDC_EDIT_DEVICEID, m_strDeviceID);
   DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
   //{{AFX_DATA_MAP(CMyReadDIODlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyReadDIODlg, CDialog)
   //{{AFX_MSG_MAP(CMyReadDIODlg)
   ON_WM_PAINT()
   ON_WM_QUERYDRAGICON()
   ON_BN_CLICKED(ID_EXIT, OnExit)
   ON_BN_CLICKED(ID_READDIO, OnReaddio)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyReadDIODlg message handlers

BOOL CMyReadDIODlg::OnInitDialog()
{
   int    tcp_err;
   char   szDump[80];

   CDialog::OnInitDialog();

   // Set the icon for this dialog.  The framework does this automatically
   //  when the application's main window is not a dialog
   SetIcon(m_hIcon, TRUE);       // Set big icon
   SetIcon(m_hIcon, FALSE);      // Set small icon

   // TODO: Add extra initialization here
   m_strIPAddress="192.168.0.52";
   SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

   // DLL version
   char   szCh[10];
   int    DLLVersion;
   DLLVersion=TCP_GetDLLVersion();
   _ltoa( DLLVersion, szCh, 16 );
   SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    //Initial DLL to working ---
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }

   return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyReadDIODlg::OnPaint()
{
   if (IsIconic())
   {
      CPaintDC dc(this); // device context for painting

      SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

      // Center icon in client rectangle
      int cxIcon = GetSystemMetrics(SM_CXICON);
      int cyIcon = GetSystemMetrics(SM_CYICON);
      CRect rect;
      GetClientRect(&rect);
      int x = (rect.Width() - cxIcon + 1) / 2;
      int y = (rect.Height() - cyIcon + 1) / 2;

      // Draw the icon
      dc.DrawIcon(x, y, m_hIcon);
   }
   else
   {
      CDialog::OnPaint();
   }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyReadDIODlg::OnQueryDragIcon()
{
   return (HCURSOR) m_hIcon;
}
void CMyReadDIODlg::OnExit()
{
    //--- Finally, release some resource that DLL allocated---
   TCP_Close();

   // TODO: Add your control notification handler code here
   CDialog::OnOK();
}

void CMyReadDIODlg::OnReaddio()
{
   // TODO: Add your control notification handler code here
   CString   strText,strTemp;
   char      szIPAddress[20];
   int       i,tcp_err;
   char      szDump[80];
   BYTE      byDI[16], byDO[16];

   GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

   //create a connection to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,
              iConnectionTimeout, iSendTimeout, iReceiveTimeout);

    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        return;
    }

   //-- Get Module name ---//
    char   szMoudleNo[20];
    tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
    SetDlgItemText(IDC_NAME, szMoudleNo);

   //-- Get Id number ---//
   char  IDno, szId[20];
   TCP_GetModuleID(szIPAddress,&IDno);
   sprintf (szId,"%d",IDno);
   SetDlgItemText(IDC_EDIT_DEVICEID, szId);

   for(i=0; i<16; i++)
   {
      byDI[i]=byDO[i]=127;
   }

   //Get the coil's registers
    tcp_err=TCP_ReadDIO(szIPAddress, byDI, byDO);
    if( tcp_err )
    {
        sprintf(szDump,"TCP_ReadDIO() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

   //show the DI value
   ((CListBox*)GetDlgItem(IDC_LIST_DIVALUE))->ResetContent();
   for(i=0; i<16 && byDI[i]!=127; i++)
   {
      strText.Format( "DI:%02d -> %d", i,byDI[i]);
      ((CListBox*)GetDlgItem(IDC_LIST_DIVALUE))->InsertString( -1, strText );
   }
   //show the DO value
   ((CListBox*)GetDlgItem(IDC_LIST_DOVALUE))->ResetContent();
   for(i=0; i<6 && byDO[i]!=127; i++)
   {
      strText.Format( "DO:%02d -> %d", i,byDO[i]);
      ((CListBox*)GetDlgItem(IDC_LIST_DOVALUE))->InsertString( -1, strText );
   }

    //--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();

}
