// SendRecvTCPDlg.cpp : implementation file
//


#include "stdafx.h"
#include "SendRecvTCP.h"
#include "SendRecvTCPDlg.h"

#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

#define DEFAULT_PORT 502   // Modbus/TCP's Port
#define DeviceID     0x01  // 0x01 indicate the EX-9000MTCP's ID

//-------- Set timeout value ------
int     iConnectionTimeout=2000;
int     iSendTimeout=2000;
int     iReceiveTimeout=2000;


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMySendRecvTCPDlg dialog

CMySendRecvTCPDlg::CMySendRecvTCPDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMySendRecvTCPDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMySendRecvTCPDlg)
	m_strIPAddress = _T("");
	m_strResponse = _T("");
	m_strSend = _T("");
   //}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMySendRecvTCPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMySendRecvTCPDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	DDX_Text(pDX, IDC_EDIT_RESPONSE, m_strResponse);
	DDX_Text(pDX, IDC_EDIT_SEND, m_strSend);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMySendRecvTCPDlg, CDialog)
	//{{AFX_MSG_MAP(CMySendRecvTCPDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_SENDCOMMAND, OnSendcommand)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMySendRecvTCPDlg message handlers

BOOL CMySendRecvTCPDlg::OnInitDialog()
{
	int    tcp_err;
	char   szDump[80];

	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.52";
	m_strSend="$01F";
	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);
	SetDlgItemText(IDC_EDIT_SEND,m_strSend);

	// get the DLL version
	char   szCh[20];
    int    DLLVersion;

	DLLVersion=TCP_GetDLLVersion();
	_ltoa( DLLVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    //--- Firstly, initial DLL to working ---
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMySendRecvTCPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMySendRecvTCPDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
void CMySendRecvTCPDlg::OnExit()
{
    //--- Finally, release some resource that DLL allocated---
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

char      szCmd[200],szResponse[200];
//char      szModbusCmd[200],szModbusResponse[200];
void CMySendRecvTCPDlg::OnSendcommand()
{
	// TODO: Add your control notification handler code here
    CString   strText,strTemp;
	char      szIPAddress[20];
	int       tcp_err;
	char      szDump[80];

    //--- get the EX-9000MTCP's IP Address ---
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

	//--- try to create a connection to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

	// Get the command send to EX-9000MTCP
	GetDlgItemText(IDC_EDIT_SEND,szCmd,20);

    //send a ASCII command to EX-9000MTCP and receive response
    tcp_err=TCP_SendReceiveASCcmd(szIPAddress, szCmd, szResponse);
    if( tcp_err )
    {
        sprintf(szDump,"TCP_SendReceive5KTCPCmd() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

    //Show various message ---
	SetDlgItemText(IDC_EDIT_RESPONSE,szResponse);
	//--- Disconnect to EX-9000MTCP ---
    TCP_Disconnect();

}
