// SetDODlg.cpp : implementation file
//

#include "stdafx.h"
#include "SetDO.h"
#include "SetDODlg.h"
#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define DEFAULT_PORT 502
#define iConnectionTimeout 2000
#define iSendTimeout 2000
#define iReceiveTimeout 2000

/////////////////////////////////////////////////////////////////////////////
// CSetDODlg dialog

CSetDODlg::CSetDODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetDODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetDODlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSetDODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetDODlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetDODlg, CDialog)
	//{{AFX_MSG_MAP(CSetDODlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_SETDO, OnSetdo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetDODlg message handlers

BOOL CSetDODlg::OnInitDialog()
{
	int    tcp_err;
	char   szDump[80];

	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.52";
	m_strStartDO="0";
	m_strNoOfWrite="8";
	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);
	SetDlgItemText(IDC_EDIT_STARTDO,m_strStartDO);
	SetDlgItemText(IDC_EDIT_NOOFWRITE,m_strNoOfWrite);

    //--- initial all the DO to 0 ---
	CButton*  pRadioButton;
	int       nID,i;

    nID=IDC_RADIO1;
	for(i=0; i<16; i++)
	{

	    pRadioButton=(CButton *)GetDlgItem(nID+2*i);
		pRadioButton->SetCheck(BST_CHECKED);
	}

	// DLL version
	char   szCh[20];
   int    DLLVersion;    
 
	DLLVersion=TCP_GetDLLVersion();
	_ltoa( DLLVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    // initial DLL to working
    tcp_err=TCP_Open();
    if( tcp_err!=0 )
    {
        sprintf(szDump,"TCP_Open() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
    }
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSetDODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSetDODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSetDODlg::OnExit() 
{
    //--- Finally, release some resource that DLL allocated---
	TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();		
}

void CSetDODlg::OnSetdo() 
{
	// TODO: Add your control notification handler code here
   CString   strText,strTemp;
	char      szIPAddress[20];
	int       i,nID,tcp_err;
   WORD      wStartDO;
   WORD      wCount;
   BYTE      byData[128];  
	int       DOValue[16];
	CButton*  pRadioButton;
	char      szDump[80];

   nID=IDC_RADIO1;
	for(i=0; i<16; i++)
	{

	    pRadioButton=(CButton *)GetDlgItem(nID+2*i);
		if( pRadioButton->GetCheck()==BST_CHECKED )
			DOValue[i]=0;
		else
			DOValue[i]=1;
	}

	// Number of DO to write
	GetDlgItemText(IDC_EDIT_NOOFWRITE,strTemp);
	wCount=atoi(strTemp);
	if( wCount<0 || wCount>16 )
	{
		MessageBox("The # of D/O must between 1 to 16 !");
		return;
	}

   // start address of DO channel
	GetDlgItemText(IDC_EDIT_STARTDO,strTemp);
	wStartDO=atoi(strTemp);

    // get the EX-9000MTCP's IP
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);
    
	//create a connection to EX-9000MTCP ---
    tcp_err=TCP_Connect(szIPAddress,DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);

    if( tcp_err<0 )
    {
        sprintf(szDump,"TCP_Connect() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
    }

   //-- Get Module name ---//
   char   szMoudleNo[20];
   tcp_err=TCP_GetModuleNo(szIPAddress,szMoudleNo);
   SetDlgItemText(IDC_NAME, szMoudleNo);

   //-- Get Id number ---//
   char  IDno, szId[20];
   TCP_GetModuleID(szIPAddress,&IDno);
   sprintf (szId,"%d",IDno);
   SetDlgItemText(IDC_EDIT_DEVICEID, szId);

   //--- prepare data to write to DO channels ---
	for(i=0; i<wCount; i++)
		byData[i]=DOValue[wStartDO+i];

   //--- write the coil's registers---
	tcp_err=TCP_WriteDO(szIPAddress,  wStartDO, wCount, byData);

   if( tcp_err )
   {
        sprintf(szDump,"TCP_WriteDO() Failure !!!   code=%d\n",tcp_err);
        MessageBox(szDump);
        TCP_Disconnect();
        return;
   }

   //--- Disconnect to EX-9000MTCP ---
   TCP_Disconnect();
}


