// StreamPollDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StreamPoll.h"
#include "StreamPollDlg.h"

#include <winsock2.h>
#include "..\..\..\include\tcpdaq.h"

UINT ThreadProc( LPVOID lpParam );

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char			szIPAddress[20];
static int		iTotalReceive;
static int		iTotalTimeout;
static int		iThreadIndex;
//----------------------------------------------
struct _StreamData   *pStreamData,StreamData;
static BYTE byLoopFlag=1;
HANDLE    hEvent;
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStreamPollDlg dialog

CStreamPollDlg::CStreamPollDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CStreamPollDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStreamPollDlg)
	m_strIPAddress = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CStreamPollDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStreamPollDlg)
	DDX_Text(pDX, IDC_EDIT_IPADDRESS, m_strIPAddress);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStreamPollDlg, CDialog)
	//{{AFX_MSG_MAP(CStreamPollDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_EXIT, OnExit)
	ON_BN_CLICKED(ID_START, OnStart)
	ON_BN_CLICKED(ID_STOP, OnStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStreamPollDlg message handlers

BOOL CStreamPollDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	m_strIPAddress="192.168.0.17"; //The module's IP
	SetDlgItemText(IDC_EDIT_IPADDRESS,m_strIPAddress);

	// Read the DLL version
	char   szCh[20];
    int    DLLVersion;

	DLLVersion=TCP_GetDLLVersion();
	_ltoa( DLLVersion, szCh, 16 );
	SetDlgItemText(IDC_EDIT_DLLVER, szCh);

    (CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );

    //------ Initialize DLL to work -------
    int   ReturnValue;

    ReturnValue=TCP_Open();
    if( ReturnValue!=0 )
    {
        MessageBox("TCP_Open() Failure !!!");
    }
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStreamPollDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CStreamPollDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CStreamPollDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CStreamPollDlg::OnExit()
{
    //Calling TCP_Close() to release all allocated resource  ---
    TCP_Close();

	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CStreamPollDlg::OnStart()
{
	// TODO: Add your control notification handler code here
    //char      szDump[80];
	int       ReturnValue;
    CString   strText,strTemp;

	(CButton *)GetDlgItem(ID_START)->EnableWindow( FALSE );
    (CButton *)GetDlgItem(ID_STOP)->EnableWindow( TRUE );
	(CButton *)GetDlgItem(ID_EXIT)->EnableWindow( FALSE );

	m_bStopThread = FALSE;
	m_pThread = NULL;

    m_iTotalReceive=0;
    m_iTotalTimeout=0;
    m_iThreadIndex=0;

    // Get the module's IP Address
	GetDlgItemText(IDC_EDIT_IPADDRESS,szIPAddress,20);

    //Create a event for synchronization
    hEvent = CreateEvent(NULL,
			     FALSE,   // auto reset
			     FALSE,  // init state as Non-Signal
			     NULL);

	((CListBox*)GetDlgItem(IDC_LIST_STREAM))->ResetContent();
    m_pListBox=(CListBox*)GetDlgItem(IDC_LIST_STREAM);

	if( m_pThread == NULL )
	{

		m_ThreadData.hEvent = &hEvent;
		m_ThreadData.lpStopThread = &m_bStopThread;
		m_ThreadData.TotalReceive=&m_iTotalReceive;
        m_ThreadData.TotalTimeout=&m_iTotalTimeout;
        m_ThreadData.ThreadIndex=&m_iThreadIndex;
		m_ThreadData.pListBox=m_pListBox;


		// Start the thread.
		m_pThread =
			AfxBeginThread(ThreadProc, (LPVOID) &m_ThreadData);
	}


    //Start to receive the stream data come from EX-9000MTCP
    ReturnValue=TCP_StartStream(szIPAddress,hEvent);
    if( ReturnValue<0 )
    {
		MessageBox("TCP_AddTCPForStream() Failure !!!");
    }


}

void CStreamPollDlg::OnStop()
{
	// TODO: Add your control notification handler code here
	HANDLE hThread = m_pThread->m_hThread;

	(CButton *)GetDlgItem(ID_START)->EnableWindow( TRUE );
    (CButton *)GetDlgItem(ID_STOP)->EnableWindow( FALSE );
	(CButton *)GetDlgItem(ID_EXIT)->EnableWindow( TRUE );

	// Set the flag to kill the thread to TRUE;
    m_bStopThread = TRUE;

	// Wait for the thread to end.
	::WaitForSingleObject( hThread, 1000 );

    //Stop receiving the streaming data come from EX-9000MTCP
	TCP_StopStream( );
    //Close the event handle
    CloseHandle(hEvent);

    m_iTotalReceive=0;
    m_iTotalTimeout=0;
    m_iThreadIndex=0;
}

UINT ThreadProc( LPVOID lpParam )
{
	THREAD_DATA *lpThreadData =
		(THREAD_DATA *) lpParam;
    BOOL   *bStopThread=(BOOL*)lpParam ;
	int    ReturnValue;
    CString   strText;

	while( !(*lpThreadData->lpStopThread) )
	{
		*lpThreadData->ThreadIndex=101;
	    {
			   if( (*lpThreadData->TotalReceive)%6==5 )
			   {
				   (lpThreadData->pListBox)->ResetContent();
			   }
			   (*lpThreadData->TotalReceive)++;


			   Sleep(1000);
			   ReturnValue=TCP_ReadStreamData(szIPAddress,&StreamData);
			   pStreamData=(struct _StreamData *)&StreamData;

		       strText.Format( "Receive:%d", *lpThreadData->TotalReceive);
		       (lpThreadData->pListBox)->InsertString( -1, strText );

			   //------Print the DI/O's value------
			   strText.Format ("------DI/DO Data------");
			   strText.Format("THE DI Value=%03x  THE DO Value=%03x\n",pStreamData->DIN,pStreamData->DOUT);
			   (lpThreadData->pListBox)->InsertString( -1, strText );

			   //------Print Module's IP------
			   strText.Format("THE MODULE'S IP ADDRESS %d.%d.%d.%d",pStreamData->szIP[0],pStreamData->szIP[1],
																	 pStreamData->szIP[2],pStreamData->szIP[3]);
			   (lpThreadData->pListBox)->InsertString(-1,strText);

			   //------Print time------
			   strText.Format("Time %d/%d/%d %d:%d:%d",pStreamData->szDateTime[0],pStreamData->szDateTime[1],
														pStreamData->szDateTime[2],pStreamData->szDateTime[3],
														pStreamData->szDateTime[4],pStreamData->szDateTime[5]);
			   (lpThreadData->pListBox)->InsertString(-1,strText);


		}
	}
	(*lpThreadData->ThreadIndex)=102;
	return 0;
}

