//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtVersion: TEdit;
    Label2: TLabel;
    edtIPAddress2: TEdit;
    Label3: TLabel;
    memoMsg2: TMemo;
    btnExit: TButton;
    btnStart: TButton;
    btnStop: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  bLoopFlag: bool;
  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

     close();
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin
   //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

procedure TForm1.btnStartClick(Sender: TObject);
var
   iRecCount    : Integer;
   iRecCount2   : Integer;
   ReturnValue  : Integer;
   hEvent       : Integer;
   EventData    : TEventInfo;
   EventData2   : TEventInfo;

 //  strMsg           : string;
 //  iMatchIndex,iReceiveCount,iThreadRun,iTotalEvent : Integer;
   szFromIP         : PChar;
   sel            :word;
begin

   btnStart.Enabled:=false;
   btnStop.Enabled:=true;

   //-----  create a event ---------------
   hEvent := CreateEvent(NIL,FALSE,FALSE,NIL);

   //--- adding the first Event ----
   ReturnValue:=TCP_startEvent(pchar(edtIPAddress.Text),hEvent);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('TCP_startEvent()!, Error Code:'  );
        exit;
   end;

   //--- adding the second  Eventing ----
   ReturnValue:=TCP_StartEvent(pchar(edtIPAddress2.Text) ,hEvent);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('TCP_startEvent()!, Error Code:'  );
        exit;
   end;

   szFromIP:=StrAlloc(80);
   bLoopFlag:=TRUE;
   iRecCount:=0;
   iRecCount2:=0;
   sel:=0;
   memoMsg.Lines.Clear();
   memoMsg2.Lines.Clear();
   //--- Starting to receive the Eventing data ---
   while( bLoopFlag ) do
   begin
      if ( WaitForSingleObject(hEvent, 1000) = WAIT_OBJECT_0 ) then
      begin
//===========

//   szIP        : array[0..3] of Byte ;       //The IP address which cause the alarm change
//   szDateTime  : array[0..5] of Integer;     //E.x 2001/09/23 10:12:34:567 (Year/Month/Day Hour:Minute:Second:mSecond)
//   byChannel   : Integer;                    //The Channel of which cause the alarm change
//   byAlarmType : Integer;                    //0x00:AIO Low Alarm
                                             //0x01:AIO High Alarm
                                             //0x20:DIO Alarm
                                             //0xF0:Connection Alarm
//   byAlarmStatus : Integer;                  //0:Alarm ON to OFF, 1:Alarm OFF to ON
//   wValue : Integer  ;                       //Alarm value.For DIO, this value could be "0" or "1" means that "ON" or "OFF"
                                             //            For high or low alarm, this is the AIO value.
                                             //            For connection lost, this value is 0.
//End;
//===========              
             if (TCP_ReadEventData(pchar(edtIPAddress.Text),EventData)=0) then
             begin
                if( (iRecCount mod 4)=3 ) then
                begin
                    memoMsg.Lines.Clear();
                end;
                inc(iRecCount);
                memoMsg.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount));
                memoMsg.Lines.Add('Alarm Channel:'+IntToStr(EventData.byChannel));
                memoMsg.Lines.Add('Alarm Type   :'+IntToStr(EventData.byAlarmType));
                memoMsg.Lines.Add('Alarm Status :'+IntToStr(EventData.byAlarmStatus));
                memoMsg.Lines.Add('Alarm Value :'+INTTOHEX(EventData. wValue,4));
                memoMsg.Lines.Add('   ');

            end;

            if (TCP_ReadEventData(pchar(edtIPAddress2.Text),EventData)=0) then
            begin
                if( (iRecCount2 mod 4)=3 ) then
                begin
                    memoMsg2.Lines.Clear();
                end;
                inc(iRecCount2);
                ReturnValue:=TCP_ReadEventData(pchar(edtIPAddress2.Text),EventData2);
                memoMsg2.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount2));
                memoMsg2.Lines.Add('Alarm Channel:'+IntToStr(EventData2.byChannel));
                memoMsg2.Lines.Add('Alarm Type   :'+IntToStr(EventData2.byAlarmType));
                memoMsg2.Lines.Add('Alarm Status :'+IntToStr(EventData2.byAlarmStatus));
                memoMsg2.Lines.Add('Alarm Value :'+INTTOHEX(EventData2. wValue,4));
                memoMsg2.Lines.Add('   ');

            end;
      end;
      Application.ProcessMessages();
   end;

   StrDispose(szFromIP);
   TCP_StopEvent();
   CloseHandle(hEvent);

end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
    bLoopFlag:=FALSE;
    btnStart.Enabled:=true;
    btnStop.Enabled:=false;
end;
end.
