//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    Label5: TLabel;
    Label4: TLabel;
    edtID: TEdit;
    Label6: TLabel;
    btnRead: TButton;
    btnExit: TButton;
    edtVersion: TEdit;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin
     //------- Disconnect to EX-9000 -------
     TCP_Disconnect();
     TCP_Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   byData           : Array [0..127] of Byte;
   Mid              : Byte;

   begin

        //--- Connect to EX-9000 ---
        ReturnValue := TCP_Connect(PChar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( ReturnValue<0 ) then
        begin
           ShowMessage('TCP_Connect() Failure!, Error Code:' + IntToStr(ReturnValue) );
          exit;
        end;


        TCP_GetModuleID(PChar(edtIPAddress.Text),  @Mid) ;
        edtId.Text:=   IntToStr(Mid);

        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        
        if ( (wCount<1) or (wCount>128) ) then
        begin
           ShowMessage('No. have to between 1 to 128');
           exit;
        end;
        
        //--- TCP_MODBUS_ReadCoil---
	    for i := 0 to wCount - 1 do
	        byData[i] := 255;
        
        ReturnValue := TCP_MODBUS_ReadCoil(PChar(edtIPAddress.Text),  wStartAddress, wCount, @byData);
        if ( ReturnValue <> 0 ) then
        begin
           ShowMessage('TCP_MODBUS_ReadCoil() Failure!, Error Code:' + IntToStr(ReturnValue) );
           TCP_Disconnect();
           TCP_Close();
           close;
        end;

        memoMsg.Lines.Clear();
        j := wStartAddress;
     	for i:=0 to wCount -1 do
        begin
           memoMsg.Lines.Add('Address:' + IntToStr(j)+ '  Value:' + IntToStr(byData[i]) );
           inc( j );
        end;

end;


procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin
    //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

end.
