//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtID: TEdit;
    Label4: TLabel;
    btnRead: TButton;
    btnExit: TButton;
    edtVersion: TEdit;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

    //------- Disconnect to EX-9000 -------
    TCP_Disconnect();
    TCP_Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   wData            : Array [0..63] of WORD;
   Mid              : Byte;
begin
        //--- Connect to EX-9000 ---
        ReturnValue:= TCP_Connect(PChar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( ReturnValue<0 ) then
        begin
           ShowMessage('Connect Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;

        //--- Get module Id number --//
        TCP_GetModuleID(PChar(edtIPAddress.Text),  @Mid) ;
        edtId.Text:=   IntToStr(Mid);  
        
        
        //--- Read Register ---//
        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        if ( (wCount<1) or (wCount>64) ) then
        begin
           ShowMessage('No. have to between 1 to 64');
           exit;
        end;

        for i := 0 to wCount - 1 do
           wData[i] := $1234;
        ReturnValue := TCP_MODBUS_ReadReg(pchar(edtIPAddress.Text),wStartAddress, wCount, @wData);
        if ( ReturnValue <> 0 ) then
        begin
           exit;
        end;

        memoMsg.Lines.Clear();
        j := wStartAddress;
        for i:=0 to wCount -1 do
        begin
           memoMsg.Lines.Add('Address:' + IntToStr(j)+ ' Value:' + IntToHex(wData[i],4)+ '[hex]   Value:' + IntToStr(wData[i]) );
           inc( j );
        end;

end;
procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin
  //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

end.
