//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;
 
type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtStartAddress: TEdit;
    Label3: TLabel;
    edtCount: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    edtData0: TEdit;
    edtData1: TEdit;
    edtData2: TEdit;
    edtData3: TEdit;
    edtData4: TEdit;
    edtData5: TEdit;
    edtData6: TEdit;
    edtData7: TEdit;
    edtData8: TEdit;
    edtData9: TEdit;
    edtData10: TEdit;
    edtData11: TEdit;
    edtData12: TEdit;
    edtData13: TEdit;
    edtData14: TEdit;
    edtData15: TEdit;
    edtID: TEdit;
    Label36: TLabel;
    Label37: TLabel;
    btnExit: TButton;
    edtVersion: TEdit;
    btnWrite: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnWriteClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPdaq;

procedure TForm1.btnExitClick(Sender: TObject);
begin
    //------- Disconnect to EX-9000 -------
    TCP_Disconnect();
    TCP_Close();
    Close();
end;

procedure TForm1.btnWriteClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   wStartAddress    : WORD;
   wCount           : WORD;
   wData            : Array [0..63] of WORD;
   Mid              : Byte;

begin

        //--- Connect to EX-9000 ---
        ReturnValue  := TCP_Connect(PChar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( ReturnValue <0 ) then
        begin
           ShowMessage('TCP_Connect() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;


       //--- Get module Id number --
        TCP_GetModuleID(PChar(edtIPAddress.Text),  @Mid) ;
        edtId.Text:=   IntToStr(Mid);  


        //---Set Register ---
        wStartAddress := StrToInt(edtStartAddress.Text);
        wCount := StrToInt(edtCount.Text);
        if ( (wCount<1) or (wCount>64) ) then
        begin
           ShowMessage('No. have to between 1 to 64');
           exit;
        end;

        for i := 0 to wCount - 1 do
               wData[i]:=StrToInt('$'+(FindComponent('edtData' + IntToStr(i)) As TEdit).Text);

        ReturnValue := TCP_MODBUS_WriteReg(PChar(edtIPAddress.Text), wStartAddress, wCount, @wData);
        if ( ReturnValue <> 0 ) then
        begin
           ShowMessage('TCP_MODBUS_WriteReg() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;


end;


procedure TForm1.FormCreate(Sender: TObject);
var
   ReturnValue,iVersion : Integer;
begin
   //-------- Initial DLL to working ------
   TCP_Open();
   iVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( iVersion, 4 );
end;

end.
