//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;  // Port for Modbus/TCP


type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label5: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtIPAddress: TEdit;
    edtID: TEdit;
    edtVersion: TEdit;
    memoAIMsg: TMemo;
    btnRead: TButton;
    btnExit: TButton;
    mName: TEdit;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;
 
implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

    //------- Disconnect to EX-9000 -------
     TCP_Disconnect();
     TCP_Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);
var
   i,j              : Integer;
   ReturnValue      : Integer;
   Value            : Array [0..15] of Double;
   dName            : PChar;
   Mid              : Byte;
begin
        ReturnValue   := TCP_Connect(PChar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( ReturnValue<0 ) then
        begin
           ShowMessage('TCP_Connect() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;


        //--- Get module name --
        dname:=StrAlloc (20);
        TCP_GetModuleNo (PChar(edtIPAddress.Text),dName);
        mName.Text := dName;
        StrDispose(dName);
   
       //--- Get module Id number --
        TCP_GetModuleID(PChar(edtIPAddress.Text),  @Mid) ;
        edtId.Text:=   IntToStr(Mid);

        ReturnValue := TCP_ReadAIValue(PChar(edtIPAddress.Text),@Value);
        if ( ReturnValue <> 0 ) then
        begin
           ShowMessage('TCP_ReadAI() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;

        //--- show the AI ---
        memoAIMsg.Lines.Clear();
       	for i:=0 to 7 do
        begin
           memoAIMsg.Lines.Add('CH:' + IntToStr(i)
                           + ' -> Value:' + Format('%6.3f', [Value[i]]) );
        end;
        memoAIMsg.Lines.Add('Averaging CH:' + ' ->   Value:' + Format('%6.3f', [Value[8]]) );


end;


procedure TForm1.FormCreate(Sender: TObject);
var
   ReturnValue,DLLVersion : Integer;
begin
   //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

end.
