//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    Label4: TLabel;
    Label6: TLabel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label5: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    edtIPAddress: TEdit;
    edtID: TEdit;
    edtVersion: TEdit;
    memoDIMsg: TMemo;
    memoDOMsg: TMemo;
    btnRead: TButton;
    btnExit: TButton;
    mName: TEdit;
    procedure btnExitClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation
 uses TCPDAQ;
{$R *.DFM}


procedure TForm1.btnExitClick(Sender: TObject);
begin
     //------- Disconnect to EX-9000 -------
     TCP_Disconnect();
     TCP_Close();
     close();
end;

procedure TForm1.btnReadClick(Sender: TObject);

var
    i       : Integer;
    iRetVal : Longint;
    byDI    : Array [0..15] of Byte;
    byDO    : Array [0..15] of Byte;
    dName   : pChar;
    Mid     : Byte;    
begin
        //--- Connect to EX-9000 --
        iRetVal  := TCP_Connect(PChar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( iRetVal <0 ) then
        
        begin
           ShowMessage('TCP_Connect() Failure!, Error Code:' + IntToStr(iRetVal) );
           exit;
        end;
    
        //--- Get module name --
        dname:=StrAlloc (20);
        TCP_GetModuleNo (PChar(edtIPAddress.Text),dName);

        mName.Text := dName;
        StrDispose(dName);


        //--- Get module Id number --
        TCP_GetModuleID(PChar(edtIPAddress.Text),  @Mid) ;
        edtId.Text:=   IntToStr(Mid);  


        for i := 0 to 15 do
        begin
            byDI[i]:=255;
            byDO[i]:=255;
        end;

        iRetVal := TCP_ReadDIO(PChar(edtIPAddress.Text), @byDI, @byDO);
        if ( iRetVal <> 0 ) then
        begin
           ShowMessage('TCP_ReadDIO() Failure!, Error Code:' + IntToStr(iRetVal) );
           exit;
        end;

        //--- show ---
        memoDIMsg.Lines.Clear();
        for i:=0 to 15 do
        begin
        if byDI[i]=255 then break;
           memoDIMsg.Lines.Add('DI:' + IntToStr(i)
                           + '   Value:' + IntToStr(byDI[i]) );
        end;
        //--- show the D/O ---
        memoDOMsg.Lines.Clear();
        for i:=0 to 15 do
        begin
        if byDO[i]=255 then break;
           memoDOMsg.Lines.Add('DO:' + IntToStr(i)
                           + '   Value:' + IntToStr(byDO[i]) );
        end;


end;


procedure TForm1.FormCreate(Sender: TObject);
var
 iVersion : Integer;
begin
    //-------- Initial DLL to working ------
    TCP_Open();
   iVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( iVersion, 4 );
end;

end.
