//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;
const DEFAULT_PORT = 502;

type
  TForm1 = class(TForm)
    btnExit: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtCommand: TEdit;
    Label4: TLabel;
    edtVersion: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    edtReceive: TEdit;
    btnSend: TButton;
    RadioButton6000: TRadioButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure edtCommandKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin
     UDP_Disconnect();
     TCP_Close();
     close();
end;

procedure TForm1.btnSendClick(Sender: TObject);
var
   ReturnValue          : Integer;
   szReceive : pchar;

begin

        //--- Connect to EX-9000 ---
        ReturnValue:=UDP_Connect(pchar(edtIPAddress.Text), 0, 1025, iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if( ReturnValue<0 ) then
        begin
           ShowMessage('UDP_Connect() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;

        //--- Send an ASCII's command and receive reponse ---
         szReceive:=StrAlloc(512);
         ReturnValue := UDP_SendReceiveAsCcmd(pchar(edtIPAddress.Text), pchar(edtCommand.Text), szReceive);
        if ( ReturnValue < 0 ) then
        begin
           ShowMessage('UDP_SendReceiveAsCcmd() Failure!, Error Code:' + IntToStr(ReturnValue) );
           exit;
        end;

        edtReceive.Text:=szReceive;
        StrDispose( szReceive);

end;

procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin
   //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

procedure TForm1.edtCommandKeyPress(Sender: TObject; var Key: Char);
begin
     if Key = #13 then btnSendClick(Sender);
end;

end.
