unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;  // Port for Modbus/TCP


type
  TForm1 = class(TForm)
    btnExit: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label2: TLabel;
    edtCommand: TEdit;
    Label4: TLabel;
    edtVersion: TEdit;
    Bevel1: TBevel;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    edtReceive: TEdit;
    Label5: TLabel;
    edtModbusSend: TEdit;
    Label6: TLabel;
    edtModbusReceive: TEdit;
    Bevel3: TBevel;
    btnSend: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure edtCommandKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  //-------- default timeout ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

    //---  disconnt connection to 6000 ---
    TCP_Disconnect();
    TCP_Close();
     close();
end;

procedure TForm1.btnSendClick(Sender: TObject);
var
   iRetVal          : Longint;
   szReceive : pchar;
   sock             :Longint;

begin

        //--- try to create a connection to EX-9000 ---
        iRetVal := TCP_Connect(pchar(edtIPAddress.Text),DEFAULT_PORT,iConnectionTimeout, iSendTimeout, iReceiveTimeout);
        if ( iRetVal<0 ) then
        begin
           ShowMessage('TCP_Connect() Failure!, Error Code:' + IntToStr(iRetVal) );
           exit;
        end;

        //--- Send a command to EX-9000 and receive reponse ---

        szReceive:=StrAlloc(512);

        iRetVal := TCP_SendReceiveasCcmd(pchar(edtIPAddress.Text),pchar(edtCommand.Text), szReceive);
        if ( iRetVal <> 0 ) then
        begin
           ShowMessage('TCP_SendReceiveasCcmd() Failure!, Error Code:' + IntToStr(iRetVal) );
           exit;
        end;

        edtReceive.Text:=szReceive;
        StrDispose(szReceive);

end;

procedure TForm1.FormCreate(Sender: TObject);
var
   iVersion : Integer;
begin

   TCP_Open;
   iVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( iVersion, 4 );
end;

procedure TForm1.edtCommandKeyPress(Sender: TObject; var Key: Char);
begin
     if Key = #13 then btnSendClick(Sender);
end;

end.

