//-------------------- demo ------------------------------------//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Winsock,
  StdCtrls, ExtCtrls;

const DEFAULT_PORT = 502;


type
  TForm1 = class(TForm)
    memoMsg: TMemo;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    edtIPAddress: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    edtVersion: TEdit;
    Label2: TLabel;
    edtIPAddress2: TEdit;
    Label3: TLabel;
    memoMsg2: TMemo;
    btnExit: TButton;
    btnStart: TButton;
    btnStop: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  bLoopFlag: bool;
  //-------- Set timeout value ------
  iConnectionTimeout : Integer = 2000;
  iSendTimeout       : Integer = 2000;
  iReceiveTimeout    : Integer = 2000;

implementation

{$R *.DFM}

uses TCPDAQ;

procedure TForm1.btnExitClick(Sender: TObject);
begin

     close();
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   DLLVersion : Integer;
begin
   //-------- Initial DLL to working ------
   TCP_Open();
   DLLVersion := TCP_GetDLLVersion();
   edtVersion.Text := IntToHex( DLLVersion, 4 );
end;

procedure TForm1.btnStartClick(Sender: TObject);
var
   iRecCount    : Integer;
   iRecCount2   : Integer;
   ReturnValue          : Integer;
   hEvent           : Integer;
   StreamData       : TStreamData;
   StreamData2       : TStreamData;

 //  strMsg           : string;
 //  iMatchIndex,iReceiveCount,iThreadRun,iTotalStream : Integer;
   szFromIP         : PChar;
   sel            :word;
begin

   btnStart.Enabled:=false;
   btnStop.Enabled:=true;

   //-----  create a event ---------------
   hEvent := CreateEvent(NIL,FALSE,FALSE,NIL);

   //--- adding the first streaming ----
   ReturnValue:=TCP_startStream(pchar(edtIPAddress.Text),hEvent);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('TCP_startStream()!, Error Code:'  );
        exit;
   end;

   //--- adding the second  streaming ----
   ReturnValue:=TCP_StartStream(pchar(edtIPAddress2.Text) ,hEvent);
   if ( ReturnValue<0 ) then
   begin
        ShowMessage('TCP_startStream()!, Error Code:'  );
        exit;
   end;

   szFromIP:=StrAlloc(80);
   bLoopFlag:=TRUE;
   iRecCount:=0;
   iRecCount2:=0;
   sel:=0;
   memoMsg.Lines.Clear();
   memoMsg2.Lines.Clear();
   //--- Starting to receive the streaming data ---
   while( bLoopFlag ) do
   begin
      if ( WaitForSingleObject(hEvent, 1000) = WAIT_OBJECT_0 ) then
      begin
              
             if (TCP_ReadStreamData(pchar(edtIPAddress.Text),StreamData)=0) then
             begin
                if( (iRecCount mod 4)=3 ) then
                begin
                    memoMsg.Lines.Clear();
                end;
                inc(iRecCount);
                memoMsg.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount));
                memoMsg.Lines.Add('DIN:'+INTTOHEX(StreamData.DIN,4));
                memoMsg.Lines.Add('DOUT:'+INTTOHEX(StreamData.DOUT,4));
                memoMsg.Lines.Add('   ');
            end;

            if (TCP_ReadStreamData(pchar(edtIPAddress2.Text),StreamData)=0) then
            begin
                if( (iRecCount2 mod 4)=3 ) then
                begin
                    memoMsg2.Lines.Clear();
                end;
                ReturnValue:=TCP_ReadStreamData(pchar(edtIPAddress2.Text),StreamData2);
                inc(iRecCount2);
                memoMsg2.Lines.Add(TimeToStr(now)+'   Receive Count:' + IntToStr(iRecCount2));
                memoMsg2.Lines.Add('DIN:'+INTTOHEX(StreamData2.DIN,4));
                memoMsg2.Lines.Add('DOUT:'+INTTOHEX(StreamData2.DOUT,4));
                memoMsg2.Lines.Add('   ');
            end;
      end;
      Application.ProcessMessages();
   end;

   StrDispose(szFromIP);
   TCP_StopStream();
   CloseHandle(hEvent);

end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
    bLoopFlag:=FALSE;
    btnStart.Enabled:=true;
    btnStop.Enabled:=false;
end;
end.
